/**
 * 
 */
package com.ptteng.sca.academy.business.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.business.model.Agent;
import com.ptteng.academy.business.service.AgentService;

import java.util.List;
import java.util.Map;

public class AgentSCAClient implements AgentService {

    private AgentService agentService;

	public AgentService getAgentService() {
		return agentService;
	}
	
	
	public void setAgentService(AgentService agentService) {
		this.agentService =agentService;
	}
	
	
			   
		@Override
		public Long insert(Agent agent)throws ServiceException, ServiceDaoException{
		
		return agentService.insert(agent);
		          
		
		}	
		  
    	   
		@Override
		public List<Agent> insertList(List<Agent> agentList)throws ServiceException, ServiceDaoException{
		
		return agentService.insertList(agentList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return agentService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Agent agent)throws ServiceException, ServiceDaoException{
		
		return agentService.update(agent);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Agent> agentList)throws ServiceException, ServiceDaoException{
		
		return agentService.updateList(agentList);
		          
		
		}	
		  
    	   
		@Override
		public Agent getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return agentService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Agent> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return agentService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getAgentIdsByRegionalManagerId(Long regionalManagerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return agentService.getAgentIdsByRegionalManagerId(regionalManagerId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countAgentIdsByRegionalManagerId(Long regionalManagerId)throws ServiceException, ServiceDaoException{
		
		return agentService.countAgentIdsByRegionalManagerId(regionalManagerId);
	
	
	}
	
		
	
		@Override
	public List<Long> getAgentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return agentService.getAgentIds(start, limit);
	}

	@Override
	public Integer countAgentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return agentService.countAgentIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return agentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return agentService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   agentService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.agentService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

