package com.ptteng.academy.business.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.business.model.PersonSchool;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface PersonSchoolService extends BaseDaoService {


    public Long insert(PersonSchool PersonSchool) throws ServiceException, ServiceDaoException;


    public List<PersonSchool> insertList(List<PersonSchool> PersonSchoolList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(PersonSchool PersonSchool) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<PersonSchool> PersonSchoolList) throws ServiceException, ServiceDaoException;


    public PersonSchool getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<PersonSchool> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countPersonSchoolIdsByPersonalId(Long personalId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getPersonSchoolIdsByPersonalId(Long personalId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getPersonSchoolIdBySchoolId(Long schoolId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getPersonSchoolIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countPersonSchoolIds() throws ServiceException, ServiceDaoException;


}

