package com.ptteng.academy.business.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;
import com.ptteng.academy.business.model.Agent;

import java.util.List;

@Remotable
public interface AgentService extends BaseDaoService {

	



   		   
		
		public Long insert(Agent agent)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Agent> insertList(List<Agent> agentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Agent agent)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Agent> agentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Agent getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Agent> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAgentIdsByRegionalManagerId(Long regionalManagerId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAgentIdsByRegionalManagerId(Long regionalManagerId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAgentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAgentIds() throws ServiceException, ServiceDaoException;
	

}

