package com.ptteng.academy.business.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "teacher")
public class Teacher implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 873020015496914944L;


    /**
     * 正常
     */
    public static final Integer STATUS_ACTIVE = 1;

    /**
     * 冻结
     */
    public static final Integer STATUS_INACTIVE = 2;


    private Long id;


    private String name;


    private String mobile = "";


    private Long schoolId = -1L;


    private String subjectsStr = "";


    private Integer status = 2;


    private BigDecimal mainAmount = new BigDecimal(0);


    private BigDecimal mainAmountIos = new BigDecimal(0);


    private BigDecimal subAmount = new BigDecimal(0);


    private BigDecimal subAmountIos = new BigDecimal(0);


    private BigDecimal firstTimeAmount = new BigDecimal(0);


    private BigDecimal firstTimeAmountIos = new BigDecimal(0);


    private BigDecimal studentActivateNum = new BigDecimal(0);


    private Integer orderNum = 0;


    private Integer studentNum = 0;


    private BigDecimal totalConversionRates = new BigDecimal(0);


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "school_id")
    public Long getSchoolId() {
        return schoolId;
    }


    public void setSchoolId(Long schoolId) {
        this.schoolId = schoolId;
    }

    @Column(name = "subjects_str")
    public String getSubjectsStr() {
        return subjectsStr;
    }

    public void setSubjectsStr(String subjectsStr) {
        this.subjectsStr = subjectsStr;
    }


    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "main_amount")
    public BigDecimal getMainAmount() {
        return mainAmount;
    }


    public void setMainAmount(BigDecimal mainAmount) {
        this.mainAmount = mainAmount;
    }

    @Column(name = "main_amount_ios")
    public BigDecimal getMainAmountIos() {
        return mainAmountIos;
    }


    public void setMainAmountIos(BigDecimal mainAmountIos) {
        this.mainAmountIos = mainAmountIos;
    }

    @Column(name = "sub_amount")
    public BigDecimal getSubAmount() {
        return subAmount;
    }


    public void setSubAmount(BigDecimal subAmount) {
        this.subAmount = subAmount;
    }

    @Column(name = "sub_amount_ios")
    public BigDecimal getSubAmountIos() {
        return subAmountIos;
    }


    public void setSubAmountIos(BigDecimal subAmountIos) {
        this.subAmountIos = subAmountIos;
    }

    @Column(name = "first_time_amount")
    public BigDecimal getFirstTimeAmount() {
        return firstTimeAmount;
    }


    public void setFirstTimeAmount(BigDecimal firstTimeAmount) {
        this.firstTimeAmount = firstTimeAmount;
    }

    @Column(name = "first_time_amount_ios")
    public BigDecimal getFirstTimeAmountIos() {
        return firstTimeAmountIos;
    }


    public void setFirstTimeAmountIos(BigDecimal firstTimeAmountIos) {
        this.firstTimeAmountIos = firstTimeAmountIos;
    }

    @Column(name = "student_activate_num")
    public BigDecimal getStudentActivateNum() {
        return studentActivateNum;
    }


    public void setStudentActivateNum(BigDecimal studentActivateNum) {
        this.studentActivateNum = studentActivateNum;
    }

    @Column(name = "order_num")
    public Integer getOrderNum() {
        return orderNum;
    }


    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    @Column(name = "student_num")
    public Integer getStudentNum() {
        return studentNum;
    }


    public void setStudentNum(Integer studentNum) {
        this.studentNum = studentNum;
    }

    @Column(name = "total_conversion_rates")
    public BigDecimal getTotalConversionRates() {
        return totalConversionRates;
    }


    public void setTotalConversionRates(BigDecimal totalConversionRates) {
        this.totalConversionRates = totalConversionRates;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

