package com.ptteng.academy.admin.util;

import com.ptteng.academy.common.model.Message;
import com.ptteng.academy.common.model.UserMessageRelation;
import com.ptteng.academy.common.service.MessageService;
import com.ptteng.academy.common.service.UserMessageRelationService;
import com.ptteng.academy.user.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Created by Administrator on 2016/8/9.
 */
public class MessageUpUtil {
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMessageRelationService userMessageRelationService;

    public void messageUp(Message message) throws Exception {

        message.setPublishAt(System.currentTimeMillis());
        message.setStatus(Message.status_normal);
        List<Long> userIds = null;
        UserMessageRelation userMessageRelation = new UserMessageRelation();
        userMessageRelation.setTargetId(message.getId());

        userIds = userService.getUserIds(0, Integer.MAX_VALUE);

        for (Long userId : userIds) {
            userMessageRelation.setUserId(userId);
            userMessageRelationService.insert(userMessageRelation);
        }

    }
}
