package com.ptteng.academy.admin.util;


import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;


/**
 * Created by asus on 2016/4/14.
 */
public class ClearSignUtil {

    @Autowired
    private UserService userService;

    private Log log = LogFactory.getLog("ClearSignUtil");

    public void clearSign() throws Exception {

        log.info("==========1、遍历用户==========");
        List<Long> uids = userService.getUserIds(0, Integer.MAX_VALUE);
        List<User> users = userService.getObjectsByIds(uids);

        log.info("==========2、清空签到信息==========");
        for (User user : users) {
            log.info("uid is : " + user.getId());

            user.setSign(User.NO_SIGN);
            userService.update(user);
            log.info("clear success");
        }
    }


    public static void main(String[] args) {
        try {
            ClearSignUtil clearSignUtil = new ClearSignUtil();
            clearSignUtil.clearSign();
        }catch (Exception e){
            System.out.println(e);
        }

    }
}
