package com.ptteng.academy.admin.controller.course;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.admin.model.Article;
import com.ptteng.academy.admin.service.ArticleService;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.model.Period;
import com.ptteng.academy.course.model.Subject;
import com.ptteng.academy.course.model.Task;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.PeriodService;
import com.ptteng.academy.course.service.SubjectService;
import com.ptteng.academy.course.service.TaskService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Period  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class PeriodController {
    private static final Log log = LogFactory.getLog("period");

    @Autowired
    private PeriodService periodService;
    @Autowired
    private ArticleService articleService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private CookieUtil cookieUtil;


    /**
     * 查看课程详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/{id}", method = RequestMethod.GET)
    public String getPeriodJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        log.info("get data : id= " + id);
        try {
            Period period = periodService.getObjectById(id);
            if (period == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Long subjectId = period.getSubjectId();
            Long lessonId = period.getLessonId();
            Subject subject = subjectService.getObjectById(subjectId);
            Lesson lesson = lessonService.getObjectById(lessonId);
            if (subject != null) {
                period.setSubjectName(subject.getSubjectName());
            }
            if (lesson != null) {
                period.setLessonName(lesson.getLessonName());
            }

            log.info("get period data is " + period);

            model.addAttribute("code", 0);
            model.addAttribute("period", period);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson error,id is  " + id);
            model.addAttribute("code", -100000);
        }


        return "/academy-course-service/period/json/periodDetailJson";
    }

    /**
     * 更新课程
     *
     * @param request
     * @param response
     * @param model
     * @param period
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/{id}", method = RequestMethod.PUT)
    public String updatePeriodJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Period period, @PathVariable Long id) throws Exception {

        log.info("update period : period= " + period);

        Period periodRecord = periodService.getObjectById(id);
        if (null == periodRecord) {
            log.info("period record is null ");
            model.addAttribute("code", -5042);
            return "/common/success";

        }

        if (period == null) {
            log.info(" period is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        String periodName = period.getPeriodName();
        String frontCoverURL = period.getFrontCoverURL();
        String introText = period.getIntroText();
        Long lessonId = period.getLessonId();
        Long subjectId = period.getSubjectId();
        String appCoverURL = period.getAppCoverURL();
        Integer gradeDept = period.getGradeDept();


        if (DataUtils.isNullOrEmpty(periodName) || DataUtils.isNullOrEmpty(frontCoverURL) || DataUtils.isNullOrEmpty(introText)
                || DataUtils.isNullOrEmpty(lessonId) || DataUtils.isNullOrEmpty(subjectId)
                || DataUtils.isNullOrEmpty(gradeDept)) {

            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            period.setId(id);

            period.setSort(this.getMaxSort(null, null));
            String keyIdentity = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            Long userId = Long.valueOf(keyIdentity);

            period.setStatus(periodRecord.getStatus());
            period.setSort(periodRecord.getSort());
            period.setCreateBy(periodRecord.getCreateBy());
            period.setUpdateBy(userId);
            period.setCreateAt(periodRecord.getCreateAt());

            periodService.update(period);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update lesson error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 新增课程
     *
     * @param request
     * @param response
     * @param model
     * @param period
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period", method = RequestMethod.POST)
    public String addPeriodJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Period period) throws Exception {

        log.info("insert period : period= " + period);
        if (period == null) {
            log.info(" period is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        String periodName = period.getPeriodName();
        String frontCoverURL = period.getFrontCoverURL();
        String introText = period.getIntroText();
        Long lessonId = period.getLessonId();
        Long subjectId = period.getSubjectId();
        String appCoverURL = period.getAppCoverURL();
        Integer gradeDept = period.getGradeDept();


        if (DataUtils.isNullOrEmpty(periodName) || DataUtils.isNullOrEmpty(frontCoverURL) || DataUtils.isNullOrEmpty(introText)
                || DataUtils.isNullOrEmpty(lessonId) || DataUtils.isNullOrEmpty(subjectId)) {

            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            period.setId(null);

            // 检查是否有重名课程
            Map<String, Object> periodParam = DynamicUtil.getPeriodList(periodName, lessonId.toString(), subjectId.toString(), null, gradeDept);
            List<Long> periodList = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);

            if (null != periodList && periodList.size() > 0) {
                log.info("Already exist period which periodName is " + periodName);
                model.addAttribute("code", -5011);
                return "/common/success";
            }

            Integer maxSort = this.getMaxSort(null, null);
            period.setSort(maxSort);
            String keyIdentity = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            Long userId = Long.valueOf(keyIdentity);

            period.setStatus(Period.status_freeze);
            period.setCreateBy(userId);
            period.setCreateAt(System.currentTimeMillis());

            periodService.insert(period);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 上下架课程
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/{id}/status/{status}", method = RequestMethod.PUT)
    public String updatePeriodStatusJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Integer status)
            throws Exception {

        log.info("update period status : id= " + id);

        if (!status.equals(Period.status_normal) && !status.equals(Period.status_freeze)) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }

        try {
            Period period = periodService.getObjectById(id);

            if (null == period) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, null, id.toString(), null, Task.status_normal);
            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);

            boolean periodHasNormalTask = CollectionUtils.isNotEmpty(taskIds);

            Long lessonId = period.getLessonId();
            Long subjectId = period.getSubjectId();

            Lesson lesson = lessonService.getObjectById(lessonId);
            Subject subject = subjectService.getObjectById(subjectId);

            // 下架
            if (Period.status_freeze.equals(status)) {
                // 检查该 period 下是否有上架的 task
//                if (periodHasNormalTask) {
//                    // 不能下架
//                    model.addAttribute("code", 7);
//                    return "/common/success";
//                }

                period.setStatus(status);
                period.setUpdateBy(Long.parseLong(userId));
                periodService.update(period);
                // 检查上级
                // 检查该 period 所属 lesson下是否还有 上架的period
                Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, lessonId.toString(), null, Period.status_normal, null);
                List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
                List<Period> periodList = periodService.getObjectsByIds(periodIds);

                if (CollectionUtils.isEmpty(periodIds)) {
                    //下架lesson
                    lesson.setStatus(Lesson.status_freeze);
                    lessonService.update(lesson);
                    // 检查该 subject 下是否还有 上架的lesson
                    Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, subjectId.toString(), Subject.status_normal, null);
                    List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
                    if (CollectionUtils.isEmpty(lessonIds)) {
                        // 下架 subject
                        subject.setStatus(Subject.status_freeze);
                        subjectService.update(subject);
                    }
                }
                //下架banner
                Map<String, Object> bannerParam = DynamicUtil.getBannerListByPeriod(id);
                List<Long> bannerIds = articleService.getIdsByDynamicCondition(Article.class, bannerParam, 0, Integer.MAX_VALUE);
                if (bannerIds.size()>0){
                    List<Article> bannerList = articleService.getObjectsByIds(bannerIds);
                    for (Article article:bannerList){
                        article.setStatus(Article.Status_Unpublished);
                    }
                    articleService.updateList(bannerList);
                    log.info("Under the banner of success ,banner ids = " + bannerIds);

                }else {
                    log.info("There is no banner in the period");
                }

            }

            //上架
            if (Period.status_normal.equals(status)) {
                if (!periodHasNormalTask) {
                    // 不能上架
                    model.addAttribute("code", -4201);
                    return "/common/success";
                }
                period.setStatus(status);
                period.setUpdateBy(Long.parseLong(userId));
                periodService.update(period);

            }

            log.info("period status update : " + period);
            periodService.update(period);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update lesson error,id is  " + id);
            model.addAttribute("code", -6004);
        }
        model.addAttribute("code", 1000);
        model.addAttribute("message", "success");

        return "/common/success";
    }

    /**
     * 根据条件搜索period列表
     *
     * @param request
     * @param response
     * @param model
     * @param periodName
     * @param lessonName
     * @param size
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/period/list", method = RequestMethod.GET)
    public String getMultiPeriodJson(HttpServletRequest request,
                                     HttpServletResponse response, Integer page, ModelMap model, String periodName, String subjectName, String lessonName, Integer size, Integer status, Integer gradeDept)
            throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        // 根据subjectName 来找到对应的subjectId
        Map<String, Object> subjectParam = DynamicUtil.getSubjectList(subjectName, null, null);
        Map<String, Object> lessonParam = DynamicUtil.getLessonList(lessonName, null, null, gradeDept);

        List<Long> subjectIds = subjectService.getIdsByDynamicCondition(Subject.class, subjectParam, 0, Integer.MAX_VALUE);
        List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);

        // 将list转为String并去除括号
        String subjectIdStr = subjectIds.size() == 0 ? "' '" : subjectIds.toString();
        String lessonIdStr = lessonIds.size() == 0 ? "' '" : lessonIds.toString();

        if (subjectIdStr != "' '") {

            subjectIdStr = subjectIdStr.substring(1, subjectIdStr.length() - 1);
        }
        if (lessonIdStr != "' '") {

            lessonIdStr = lessonIdStr.substring(1, lessonIdStr.length() - 1);
        }

        Map<String, Object> periodParam = DynamicUtil.getPeriodList(periodName, lessonIdStr, subjectIdStr, status, gradeDept);

        List<Long> periodIds = periodService.getIdsByDynamicCondition(Lesson.class, periodParam, start, size);
        List<Long> count = periodService.getIdsByDynamicCondition(Lesson.class, periodParam, 0, Integer.MAX_VALUE);

        // subjectId_alias   lessonIds_alias
        List<Period> periodList = periodService.getObjectsByIds(periodIds);

        List<Long> subjectIdsR = MyListUtil.getFieldValueListFromModelList(periodList, false, Period.class.getDeclaredField("subjectId"));
        List<Long> lessonIdsR = MyListUtil.getFieldValueListFromModelList(periodList, false, Period.class.getDeclaredField("lessonId"));

        List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);
        List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);

        Map subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);
        Map lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);

        // subjectId_alias     lessonId_alias
        Integer total = count.size();
        log.info("get lesson count is " + total);

        model.addAttribute("code", 0);
        boolean next = false;
        if (periodIds.size() + start + 1 <= total) {
            next = true;
        }
        Integer totalPage = (total - 1) / size + 1;

        model.addAttribute("next", next);
        model.addAttribute("totalPage", totalPage);
        model.addAttribute("page", page);
        model.addAttribute("size", size);
        model.addAttribute("total", total);
        model.addAttribute("subjectId_alias", subjectId_alias);
        model.addAttribute("lessonId_alias", lessonId_alias);
        model.addAttribute("periodList", periodList);

        return "/academy-course-service/period/json/periodListJson";
    }

    //   通过 lessonId 查找对应的课程列表

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     * @Author tongzhirong
     */

    @RequestMapping(value = "/a/u/period/list/{lessonId} ", method = RequestMethod.GET)
    public String getPeriodListByLessonIdJsonList(HttpServletRequest request,
                                                  HttpServletResponse response, ModelMap model, @PathVariable Long lessonId) throws Exception {

        try {
            List<Long> periodIds = periodService.getPeriodIdsByLessonIDOrderBySort(lessonId, 0, Integer.MAX_VALUE);
            log.info("get period ids : " + periodIds);

            List<Period> periodList = periodService.getObjectsByIds(periodIds);

            // TODO: 2017/9/22  科目对应的专题列表判空
            if (null != periodList && periodList.size() > 0) {

                log.info("get lesson list data is " + periodList.size());
            } else {
                log.info("get lesson list data is null");
            }
            // 取得
            List<Long> subjectIds = MyListUtil.getFieldValueListFromModelList(periodList, false, Period.class.getDeclaredField("subjectId"));
            List<Long> lessonIds = MyListUtil.getFieldValueListFromModelList(periodList, false, Period.class.getDeclaredField("lessonId"));

            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIds);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);

            Map subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);
            Map lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);

            model.addAttribute("code", 0);
            model.addAttribute("periodList", periodList);
            model.addAttribute("subjectId_alias", subjectId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get period list by lessonId error, lesson id is  " + lessonId);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/period/json/periodListJson";
    }


    /*
   * 删除课程
   * @author: tongzhirong
   * */
    @RequestMapping(value = "/a/u/period/{periodId}", method = RequestMethod.DELETE)
    public String deleteLessonJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long periodId)
            throws Exception {

        log.info(" will delete period: id= " + periodId);
        try {

            Period target = periodService.getObjectById(periodId);
            if (null == target) {
                log.info("there are no period which Id is" + periodId);
            }
            boolean delete = periodService.delete(periodId);
            if (delete == true) {

                log.info("delete lesson success");
            } else {
                log.info("delete lesson failure");

            }
            model.addAttribute("code", 0);

            Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, null, periodId.toString(), null, null);

            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);

            if (null != taskIds && taskIds.size() > 0) {
                taskService.deleteList(Task.class, taskIds);
                log.info("successfully delete taskIds " + taskIds + " under periodId " + periodId);
            } else {
                log.info("There are no tasks under lessonId " + periodId);
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete subject error, id is  " + periodId);
            model.addAttribute("code", -6004);

        }

        model.addAttribute("code", 1000);
        model.addAttribute("message", "success");

        return "/data/json";
    }


    /**
     * 排序课程
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Period> periodList = periodService.getObjectsByIds(ids);

            int index = 1;
            for (Period period : periodList) {
                period.setSort(index);
                index = index + 1;
            }
            this.periodService.updateList(periodList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort period error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    private Integer getMaxSort(Long lessonId, Integer level) throws ServiceException, ServiceDaoException {

        Map<String, Object> param = DynamicUtil.getPeriodList(null, null, null, null, null);
        List<Long> maxs = this.periodService.getIdsByDynamicCondition(
                Period.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.periodService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }


}

