package com.ptteng.academy.admin.controller;

import com.ptteng.academy.document.model.VideoGradeRelation;
import com.ptteng.academy.document.service.VideoGradeRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * VideoGradeRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class VideoGradeRelationController {
	private static final Log log = LogFactory.getLog(VideoGradeRelationController.class);

	@Autowired
	private VideoGradeRelationService videoGradeRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/videoGradeRelation", method = RequestMethod.GET)
	public String getvideoGradeRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/videoGradeRelation  to /videoGradeRelation/view/videoGradeRelationList");

		return "/academy-user-service/videoGradeRelation/view/videoGradeRelationList";
	}
    
    

    
	
	@RequestMapping(value = "/c/videoGradeRelation/{id}", method = RequestMethod.GET)
	public String getVideoGradeRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/videoGradeRelation/" + id + "  to /videoGradeRelation/view/videoGradeRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/academy-user-service/videoGradeRelation/view/videoGradeRelationDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/videoGradeRelation/{id}", method = RequestMethod.GET)
	public String getVideoGradeRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			VideoGradeRelation videoGradeRelation = videoGradeRelationService.getObjectById(id);
			log.info("get videoGradeRelation data is " + videoGradeRelation);

			model.addAttribute("code", 0);

			model.addAttribute("videoGradeRelation", videoGradeRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get videoGradeRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/videoGradeRelation/json/videoGradeRelationDetailJson";
	}

	@RequestMapping(value = "/a/videoGradeRelation/{id}", method = RequestMethod.PUT)
	public String updateVideoGradeRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, VideoGradeRelation videoGradeRelation) throws Exception {
		
		log.info("update videoGradeRelation : videoGradeRelation= " + videoGradeRelation);
		
		try {
			
			videoGradeRelationService.update(videoGradeRelation);

			model.addAttribute("code", 0);

			model.addAttribute("videoGradeRelation", videoGradeRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update videoGradeRelation error,id is  " + videoGradeRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/videoGradeRelation", method = RequestMethod.POST)
	public String addVideoGradeRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, VideoGradeRelation videoGradeRelation) throws Exception {
		
		log.info("update videoGradeRelation : videoGradeRelation= " + videoGradeRelation);
		
		try { 
			videoGradeRelation.setId(null);

			videoGradeRelationService.insert(videoGradeRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add videoGradeRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/videoGradeRelation/{id}", method = RequestMethod.DELETE)
	public String deleteVideoGradeRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete videoGradeRelation : id= " + id);
		try {
			videoGradeRelationService.delete(id);

			log.info("add videoGradeRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete videoGradeRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/videoGradeRelation", method = RequestMethod.GET)
	public String getMultiVideoGradeRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<VideoGradeRelation> videoGradeRelationList = videoGradeRelationService.getObjectsByIds(idList);
			log.info("get  videoGradeRelation data is " + videoGradeRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",videoGradeRelationList.size());

			model.addAttribute("videoGradeRelationList", videoGradeRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get videoGradeRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/videoGradeRelation/json/videoGradeRelationListJson";
	}
	
	
	
	
	
}

