package com.ptteng.academy.admin.controller.system;

import com.ptteng.academy.admin.model.Opinion;
import com.ptteng.academy.admin.service.OpinionService;
import com.ptteng.academy.admin.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Opinion  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class OpinionController {
    private static final Log log = LogFactory.getLog(OpinionController.class);

    @Autowired
    private OpinionService opinionService;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/c/opinion", method = RequestMethod.GET)
    public String getopinionList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model) throws Exception {


        log.info("/opinion  to /opinion/view/opinionList");

        return "/academy-public-service/opinion/view/opinionList";
    }


    @RequestMapping(value = "/c/opinion/{id}", method = RequestMethod.GET)
    public String getOpinion(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("/opinion/" + id + "  to /opinion/view/opinionDeail");
        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", 0);
        }

        return "/academy-public-service/opinion/view/opinionDetail";
    }


    @RequestMapping(value = "/a/opinion/{id}", method = RequestMethod.GET)
    public String getOpinionJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Opinion opinion = opinionService.getObjectById(id);
            log.info("get opinion data is " + opinion);

            model.addAttribute("code", 0);

            model.addAttribute("opinion", opinion);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get opinion error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/academy-public-service/opinion/json/opinionDetailJson";
    }

    @RequestMapping(value = "/a/opinion/{id}", method = RequestMethod.PUT)
    public String updateOpinionJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Opinion opinion) throws Exception {

        log.info("update opinion : opinion= " + opinion);

        try {

            opinionService.update(opinion);

            model.addAttribute("code", 0);

            model.addAttribute("opinion", opinion);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update opinion error,id is  " + opinion.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    @RequestMapping(value = "/a/opinion", method = RequestMethod.POST)
    public String addOpinionJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Opinion opinion) throws Exception {

        log.info("update opinion : opinion= " + opinion);

        try {
            opinion.setId(null);

            opinionService.insert(opinion);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add opinion error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/a/opinion/{id}", method = RequestMethod.DELETE)
    public String deleteOpinionJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete opinion : id= " + id);
        try {
            opinionService.delete(id);

            log.info("add opinion success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete opinion error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/a/multi/opinion", method = RequestMethod.GET)
    public String getMultiOpinionJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Opinion> opinionList = opinionService.getObjectsByIds(idList);
            log.info("get  opinion data is " + opinionList);

            model.addAttribute("code", 0);
            model.addAttribute("total", opinionList.size());

            model.addAttribute("opinionList", opinionList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get opinion error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/academy-public-service/opinion/json/opinionListJson";
    }


    @RequestMapping(value = "/a/u/opinion/list", method = RequestMethod.GET)
    public String getOpinion(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String name, String mail, Integer page, Integer size, Long startAt, Long endAt)
            throws Exception {

        log.info("get Opinion list name is " + name + " mail is " + mail);

        List<Opinion> opinionList = new ArrayList<>();
        Integer total = null;
        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> param = DynamicUtil.getOpinionList(name, mail, startAt, endAt);
            total = opinionService.getIdsByDynamicCondition(Opinion.class, param, 0, Integer.MAX_VALUE).size();
            List<Long> ids = opinionService.getIdsByDynamicCondition(Opinion.class, param, start, size);
            log.info("get Opinion size is " + ids.size());
            log.info("get Opinion size is " + ids);
            if (ids.size() > 0) {
                opinionList = opinionService.getObjectsByIds(ids);
            }

            model.addAttribute("code", 0);
            model.addAttribute("size", size);
            model.addAttribute("page", page);

            model.addAttribute("opinionList", opinionList);
            model.addAttribute("total", total);
            log.info("-------------------------------");
//            log.info(opinionList);
            log.info("-------------------------------");

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get Opinion error,mail is  " + mail);
            model.addAttribute("code", -100000);
        }

        return "/academy-public-service/opinion/json/opinionListJson";
    }


}

