package com.ptteng.academy.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.admin.model.School;
import com.ptteng.academy.admin.service.ManagerService;
import com.ptteng.academy.admin.service.SchoolService;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.admin.util.ParseCSV;
import com.ptteng.academy.admin.util.ParseExcel;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.academy.user.service.MemberService;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserOpenidRelationService;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */

@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);
    private static final Log userLog = LogFactory.getLog(UserController.class);

    /**
     *
     */
    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    @Autowired
    private LoginRecordService loginRecordService;


    @Autowired
    private TaskService taskService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private PeriodService periodService;

    @Autowired
    private UnitService unitService;


    //1、用户详情
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.GET)
    public String getUserJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        log.info("get data : id= " + id);
        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);

            if (null == user) {
                log.info("user not exist");
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                log.info("get user : " + user);
            }
            if (null == user.getSchoolId()) {
                log.info("This user not a student");
            } else {
                School school = schoolService.getObjectById(user.getSchoolId());
                if (null == school) {
                    model.addAttribute("code", -7011);
                    return "/common/success";
                } else {
                    user.setSchoolName(school.getName());
                }
            }


            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userDetailJson";
    }


    //2、冻结解冻用户
    @RequestMapping(value = "/a/u/freeze/user/{id}", method = RequestMethod.PUT)
    public String updateUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 @PathVariable Long id, Integer status) throws Exception {

        log.info("update user : userId is= " + id + " status : " + status);

        try {
            User user = userService.getObjectById(id);
            if (user == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            if (User.STATUS_OFF != status && User.STATUS_NORMAL != status) {
                model.addAttribute("code", -1001);
                return "/common/success";
            }

            user.setStatus(status);
            userService.update(user);
            log.info("update user status " + status + " success ");

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user status error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    //3、用户列表
    @RequestMapping(value = "/a/u/user/list", method = RequestMethod.GET)
    public String getMultiUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer status,
                                   String alias, Integer grade, String mail, String mobile, Integer scoreStart,
                                   Integer scoreEnd, String location, Integer page, Integer size, Long schoolId, String className, String memberName) throws Exception {

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        log.info("get user list by : status = " + status + " alias = " + alias + " grade = " + grade + " mail = " + mail +
                " mobile = " + mobile + " minScore = " + scoreStart + " maxScore = " + scoreEnd + " location = " + location + " page = "
                + page + " size = " + size + " schoolId = " + schoolId + " className = " + className + " memberId = " + memberName);
        //学校账号仅能查看该学校学生
        Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        Long mSchoolId = managerService.getObjectById(uid).getSchoolId();
        if (mSchoolId == null) {
            log.info(" Not a school manager");
        } else {
            schoolId = mSchoolId;
            log.info(" Is a school manager, schoolId is " + schoolId);
        }


//        if (memberId != null ) {
//            Map<String,Object> param = DynamicUtil.getMemberList()
//            memberService.getIdsByDynamicCondition();
//        }


        try {
            //搜索会员类型
            //全部
            List<Long> uids = null;
            Integer isMember = null;
            Integer total = 0;
            if (memberName == null) {
                log.info("get all user");
            } else {
                switch (memberName) {
                    //非会员-搜user表
                    case Member.NOT_MEMBER:
                        log.info("Get non-member");
                        isMember = User.IS_NOT_MEMBER;
                        break;
                    //过期会员-搜user_member_relation表
                    case Member.EXPRIED_MEMBER:
                        log.info("Obtain an expired member");
                        //搜索过期订单
                        Map<String, Object> param = DynamicUtil.getUidListByUserMemberRelation(null, null, User.IS_EXPRIED_MEMBER);
                        uids = userMemberRelationService.getIdsByDynamicCondition(UserMemberRelation.class, param, 0, Integer.MAX_VALUE);
                        log.info("uids is " + uids);

                        break;
                    //正常套餐会员
                    default:
                        log.info("Get a member of type " + memberName);
                        //搜搜套餐会员
                        Map<String, Object> param2 = DynamicUtil.getUidListByUserMemberRelation(null, memberName, User.IS_MEMBER);
                        uids = userMemberRelationService.getIdsByDynamicCondition(UserMemberRelation.class, param2, 0, Integer.MAX_VALUE);
                        log.info("uids is " + uids);

                        isMember = User.IS_MEMBER;
                        break;
                }
            }

            if (uids != null && uids.size() == 0) {
                List<User> userList = new ArrayList<>();
                model.addAttribute("code", 0);
                model.addAttribute("next", false);
                model.addAttribute("total", total);
                model.addAttribute("totalPage", 1);
                model.addAttribute("userList", userList);
            }
            Map<String, Object> params = DynamicUtil.getUserList(alias, mail, mobile, grade, status, scoreStart, scoreEnd, location, schoolId, className, isMember, uids);
            idList = userService.getIdsByDynamicCondition(User.class, params, start, size);
            List<User> userList = userService.getObjectsByIds(idList);
            log.info("get  user data is " + userList.size());

            //获取用户所属学校id列表
            List<Long> schoolIds = new ArrayList<>();
            for (User user : userList) {
                if (user.getSchoolId() != null) {
                    schoolIds.add(user.getSchoolId());
                }
            }
            log.info("get  user schoolIds size is " + schoolIds.size());
            //获取学校信息
            if (schoolIds.size() > 0) {
                List<School> schoolList = schoolService.getObjectsByIds(schoolIds);
                Map<Long, String> schoolNames = new HashMap<>();
                for (School school : schoolList) {
                    schoolNames.put(school.getId(), school.getName());
                }
                //设置用户学校名称
                for (User user : userList) {
                    if (user.getSchoolId() != null) {
                        user.setSchoolName(schoolNames.get(user.getSchoolId()));
                    }
                }

            }


            Integer userCount = userService.countUserIds();

            log.info("   total = " + userCount);
            model.addAttribute("userCount", userCount);
            List<Long> usercountIds = userService.getIdsByDynamicCondition(User.class, params, 0, Integer.MAX_VALUE);
            userCount = usercountIds.size();
            Integer totalPage = (((userCount - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            total = userService.countUserIds();

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userListJson";
    }

    //修改手机号
    @RequestMapping(value = "/a/u/user/phone/{id}", method = RequestMethod.PUT)
    public String updateUserPhoneJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, @PathVariable Long id) throws Exception {
        //获取用户id
        log.info

                ("get  user data is " + id);
        //通过用户id查询user表中该条信息

        if (null != id && null != mobile) {
            User user = new User();
            user = userService.getObjectById(id);
            user.setMobile(mobile);
            userService.update(user);
            log.info

                    (user);
        } else {
            model.addAttribute("code", -1);
            return "/common/success1";
        }
        //更新该条信息

        model.addAttribute("code", 0);
        return "/common/success";
    }

    //添加逆袭都
    @RequestMapping(value = "/a/u/user/score/{id}", method = RequestMethod.PUT)
    public String addScoreJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long score, Long type, @PathVariable Long id) throws Exception {
        //获取用户id
        log.info("get  user data is " + id + "add");
        //通过用户id查询user表中该条信息
        Long userScore = null;
        if (null != id && null != score && null != type) {
            User user = new User();
            user = userService.getObjectById(id);
            if (type == 1) {
                userScore = user.getScore() + score;
            }
            if (type == 0) {
                userScore = user.getScore() - score;
            }
            if (userScore < 0) {
                model.addAttribute("code", -9200);
                return "/common/success";
            }
            user.setScore(userScore);
            userService.update(user);
        } else {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        //更新该条信息

        model.addAttribute("code", 0);
        model.addAttribute("score", userScore);

        return "/academy-user-service/user/json/userSign";
    }

    //会员详情
    @RequestMapping(value = "/a/u/user/member/{id}", method = RequestMethod.GET)
    public String getUserMemberJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info("get member data : id= " + id);

        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);

            if (null == user) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUid(id, 0, Integer.MAX_VALUE);
            List<UserMemberRelation> relations = userMemberRelationService.getObjectsByIds(memeberIds);

            if (relations.size() > 0) {
                UserMemberRelation endRelation = relations.get(0);
                model.addAttribute("vipEnd", endRelation.getEndAt());
                if (User.IS_MEMBER == endRelation.getStatus()) {
                    model.addAttribute("memberName", endRelation.getName());
                } else {
                    model.addAttribute("memberName", "过期会员");
                }
                UserMemberRelation beginRelation = relations.get(relations.size() - 1);
                model.addAttribute("vipBegin", beginRelation.getStartAt());
                Long end = endRelation.getEndAt();
                Date date = new Date();
                long time = date.getTime();
                Long deadTime = (end - time) / (86400000L);
                model.addAttribute("deadTime", deadTime);

                BigDecimal total = BigDecimal.ZERO;
                for (UserMemberRelation relation : relations) {
                    log.info("-------------------------------------------------------------");
                    BigDecimal i = relation.getPrice();
                    total = total.add(i);
                    log.info(total);

                    log.info("-------------------------------------------------------------");
                }

                model.addAttribute("totalPrice", total);

            } else {
                log.info("user not member");
                model.addAttribute("code", -2200);
                return "/common/success";
            }

//            List<Long> rids = loginRecordService.getLoginRecordIdsByUid(id, 0, Integer.MAX_VALUE);
//            List<LoginRecord> loginRecords = loginRecordService.getObjectsByIds(rids);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            //model.addAttribute("relations", relations);
            //model.addAttribute("loginRecords", loginRecords);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }


        return "/academy-user-service/user/json/userMember";
    }

    //购买记录
    @RequestMapping(value = "/a/u/order/list", method = RequestMethod.GET)
    public String getUserOrderJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
                                   Integer page, Integer size) throws Exception {
        log.info("get member data : id= " + id);

        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);

            if (null == user) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUid(id, 0, Integer.MAX_VALUE);
            List<UserMemberRelation> relations = userMemberRelationService.getObjectsByIds(memeberIds);

            if (relations.size() > 0) {
                UserMemberRelation endRelation = relations.get(0);
                model.addAttribute("vipEnd", endRelation.getEndAt());
                if (User.IS_MEMBER == endRelation.getStatus()) {
                    model.addAttribute("memberName", endRelation.getName());
                } else {
                    model.addAttribute("memberName", "过期会员");
                }
                UserMemberRelation beginRelation = relations.get(relations.size() - 1);
                model.addAttribute("vipBegin", beginRelation.getStartAt());
                Long end = endRelation.getEndAt();
                Date date = new Date();
                long time = date.getTime();
                Long deadTime = (end - time) / (86400000L);
                model.addAttribute("deadTime", deadTime);

                BigDecimal total = BigDecimal.ZERO;
                for (UserMemberRelation relation : relations) {
                }

                model.addAttribute("totalPrice", total);

            } else {
                log.info("user not member");
                model.addAttribute("code", -2200);
                return "/common/success";
            }

//            List<Long> rids = loginRecordService.getLoginRecordIdsByUid(id, 0, Integer.MAX_VALUE);
//            List<LoginRecord> loginRecords = loginRecordService.getObjectsByIds(rids);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("relations", relations);
            //model.addAttribute("loginRecords", loginRecords);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userOrder";
    }

    //登陆记录
    @RequestMapping(value = "/a/u/user/login/{uid}", method = RequestMethod.GET)
    public String getUserLoginJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long uid) throws Exception {
        User user = userService.getObjectById(uid);
        try {
            List<Long> rids = loginRecordService.getLoginRecordIdsByUid(uid, 0, Integer.MAX_VALUE);
            List<LoginRecord> loginRecords = loginRecordService.getObjectsByIds(rids);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
//            model.addAttribute("relations", relations);
            model.addAttribute("loginRecords", loginRecords);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + uid);
            model.addAttribute("code", -1);
        }

        model.addAttribute("code", 0);
        return "/academy-user-service/user/json/userLogin";
    }

    /**
     * 无需修改名字的文件尾缀，<b>必须有序存放</b> <br>
     * 例如："apk" < "jpeg" < "jpg"
     */
    private static final String[] suffixs = {"apk", "jpeg", "jpg", "png"};

    /**
     * 文件上传接口，包括图片，excel，apk等文件
     *
     * @param request
     * @param response
     * @param model
     * @param file
     * @param module
     * @return
     */
    @RequestMapping(value = "/a/u/file/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) {
        log.info("controller uploadFile begin...");
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        log.info("argument module is: " + module + ", file name is: " + file.getOriginalFilename());
        try {
      /* 第一步、文件上传前的准备工作 */
            long size = file.getSize();
            log.info("upload file size is: " + size + " bytes");
            String suffix = FileUtil.getFileExtension(file.getOriginalFilename());
            log.info("upload file suffix is: " + suffix);
            String newFileName, oldFileName = file.getOriginalFilename();
            if (Arrays.binarySearch(suffixs, suffix) >= 0) { // include
                newFileName = oldFileName;
            } else {
                newFileName = UUID.randomUUID().toString() + "." + suffix;
            }
            log.info("the newFileName is: " + newFileName);

      /* 第二步、上传文件 */
      /* 临时目录 */
            String tempDirStr = ParseExcel.FILE_PATH + "/" + module;
            log.info("tempDirStr is: " + tempDirStr);
            File tempDir = new File(tempDirStr);
            if (tempDir.exists()) {
                log.info("temp dir has exists, do not need to mkdir");
            } else {
                log.info("temp dir not exists");
                tempDir.mkdirs();
            }
      /* 临时文件 */
            String tempFileStr = tempDirStr + "/" + newFileName;
            log.info("tempFileStr is: " + tempFileStr);
            File tempFile = new File(tempFileStr);
            if (tempFile.exists()) {
                log.info("temp file has exists, do not need to touch");
            } else {
                log.info("temp file not exists");
                tempFile.createNewFile();
            }
            file.transferTo(tempFile);
            String url;

            /* 第三步、分情况上传并删除临时文件 */
            if (ParseExcel.EXCEL_SUFFIX[0].equals(suffix) || ParseExcel.EXCEL_SUFFIX[1].equals(suffix)
                    || ParseExcel.EXCEL_SUFFIX[2].equals(suffix)) {
                log.info("excel file need to parse, temporarily not to delete");
                url = tempFileStr;
            } else {
                url = imgStorageUtil.imgStorage(module, module + "/" + newFileName, tempFileStr);
                log.info("upload success, and new file name is: " + newFileName
                        + ", and new file temp dir is: " + tempDirStr + ", and access url is: " + url);
                log.info("other file need to delete");
                tempFile.delete();
                log.info(oldFileName + " delete success");
            }
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error("uploadFile error...", t);
            model.addAttribute("code", -1);
            return "/common/img";
        }
        log.info("controller uploadFile end...");
        return "/common/img";
    }

    /**
     * 批量导入用户
     *
     * @param request
     * @param response
     * @param model
     * @param excelUrl
     * @param isMember; 是否设置会员
     * @return
     */

    @RequestMapping(value = "/a/u/user/bulkimport", method = RequestMethod.POST)
    public String parseUserExcel(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 String excelUrl, Integer isMember, Long schoolId) {
        log.info("controller parseVenderTaskExcel begin...");
        log.info("arguments: excelUrl = [" + excelUrl + "], isMember = [" + isMember + "], schoolId = [" + schoolId + "]");


        try {
            //学校账户仅能导入本校学生
            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

            Long sid = managerService.getObjectById(uid).getSchoolId();
            String schoolName = null;
            if (sid == null) {
                log.info(" Not a school manager");
                if (schoolId == null) {
                    model.addAttribute("code", -7011);
                    return "data/json";
                }
            } else {
                schoolId = sid;
                log.info(" Is a school manager, schoolId is " + schoolId);
                schoolName = schoolService.getObjectById(schoolId).getName();

            }



			/* 第一步、入参的非空校验 */
            if (StringUtil.isEmpty(excelUrl)) {
                model.addAttribute("code", -1007);
                return "/data/json";
            }
            Integer memberStatus = User.IS_NOT_MEMBER;
            Member member = null;
            if (isMember == null || isMember != User.IS_MEMBER) {
                log.info(" Do not set a member ");
            } else {
                log.info(" Do set a member ");

                memberStatus = User.IS_MEMBER;
                //获取全年套餐id
                Map<String, Object> param = DynamicUtil.getMemberList(null, String.valueOf(12), String.valueOf(12), null, null, 1, false);
                List<Long> ids = memberService.getIdsByDynamicCondition(Member.class, param, 0, 1);
                if (ids.size() > 0) {
                    member = memberService.getObjectById(ids.get(0));
                }


            }
            /* 第二步、解析excel表 */
            List<User> userList = ParseExcel.parseUserExcel(excelUrl);
            //尝试更换解码方式；
            if (CollectionUtils.isEmpty(userList)) {
                log.info("file is csv");
                userList = ParseCSV.parseUserCSV(excelUrl);


            }
            if (CollectionUtils.isEmpty(userList)) {
                model.addAttribute("code", -1008);
                return "/data/json";
            }
            List<String> mobileList = new ArrayList<>();
            List<String> mailList = new ArrayList<>();

            for (User user : userList) {
                mobileList.add(user.getMobile());
                mailList.add(user.getMail());
                user.setSchoolId(schoolId);
                user.setSchoolName(schoolName);
                user.setCreateBy(uid);
                user.setUpdateBy(uid);
                user.setScore(0L);
                user.setRegisterAt(System.currentTimeMillis());
                user.setLastLoginAt(System.currentTimeMillis());
                user.setStatus(1);
                user.setWrongCount(0);
                user.setConsecutive(0);
                user.setSignHighest(0);
                user.setSign(0);
                user.setPoststatus(2);
                user.setSignTotal(0);
                user.setHollowStatus(1);
                user.setIsRead(2);
                user.setIsMember(memberStatus);
            }
            //检查手机是否注册
            Map<String, Object> mobileParam = DynamicUtil.getOpenidByMobileList(mobileList, UserOpenidRelation.TYPE_MOBILE);
            List<Long> oIdsMobile = userOpenidRelationService.getIdsByDynamicCondition(UserOpenidRelation.class, mobileParam, 0, Integer.MAX_VALUE);
            log.info("the excel openid existed , oIds is " + oIdsMobile);
            if (oIdsMobile.size() > 0) {
                List<UserOpenidRelation> openidList = userOpenidRelationService.getObjectsByIds(oIdsMobile);
                List<String> openids = new ArrayList<>();
                for (UserOpenidRelation openidRelation : openidList) {
                    openids.add(openidRelation.getOpenid());
                }
                model.addAttribute("openids", openids);
                model.addAttribute("code", -2003);
                return "/academy-user-service/user/json/userOpenidList";
            }

            //检查邮箱是否注册
            Map<String, Object> mailParam = DynamicUtil.getOpenidByMobileList(mailList, UserOpenidRelation.TYPE_MAIL);
            List<Long> oIdsMail = userOpenidRelationService.getIdsByDynamicCondition(UserOpenidRelation.class, mailParam, 0, Integer.MAX_VALUE);
            log.info("the excel openid existed , oIds is " + oIdsMail);
            if (oIdsMail.size() > 0) {
                List<UserOpenidRelation> openidList = userOpenidRelationService.getObjectsByIds(oIdsMail);
                List<String> openids = new ArrayList<>();
                for (UserOpenidRelation openidRelation : openidList) {
                    openids.add(openidRelation.getOpenid());
                }
                model.addAttribute("openids", openids);
                model.addAttribute("code", -2010);
                return "/academy-user-service/user/json/userOpenidList";
            }
            List<User> userListResult = userService.insertList(userList);
            List<UserOpenidRelation> userOpenidRelationList = new ArrayList<>();
            List<UserMemberRelation> userMemberRelationsList = new ArrayList<>();
            Long now = System.currentTimeMillis();
            //插入openid，设置会员
            for (User user : userListResult) {
                UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
                userOpenidRelation.setUid(user.getId());
                userOpenidRelation.setOpenid(user.getMobile());
                userOpenidRelation.setType(UserOpenidRelation.TYPE_MOBILE);
                userOpenidRelationList.add(userOpenidRelation);

                //设置会员
                if (member != null) {
                    UserMemberRelation userMemberRelation = new UserMemberRelation();
                    userMemberRelation.setUid(user.getId());
                    userMemberRelation.setName(member.getName());
                    userMemberRelation.setPrice(member.getPrice());
                    userMemberRelation.setPeriod(member.getPeriod());
                    userMemberRelation.setStatus(User.IS_MEMBER);
                    userMemberRelation.setStartAt(now);

                    Date startDate = new Date(now);
                    Date endDate = DateUtils.addMonths(startDate, member.getPeriod().intValue());

                    Long endAt = endDate.getTime();
                    userMemberRelation.setEndAt(endAt);

                    userMemberRelationsList.add(userMemberRelation);
                    log.info(" user " + uid + " member startAt = " + getDate(now) + " endAt = " + getDate(endAt));
                }


            }

            userOpenidRelationService.insertList(userOpenidRelationList);
            userMemberRelationService.insertList(userMemberRelationsList);


            model.addAttribute("userList", userList);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error("parseVenderTaskExcel error...", t);
            model.addAttribute("code", -1);
            return "/data/json";
        }
        log.info("controller parseUserExcel end...");
        return "/academy-user-service/user/json/userListJson";
    }


    private static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";

        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    //学习记录
    @RequestMapping(value = "/a/u/task/collection/list", method = RequestMethod.GET)
    public String getCollectionListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size, Long uid) {

        List<Long> taskIds = new ArrayList<>();
        List<Task> taskList = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        List<UserFavoriteRelation> relationList = new ArrayList<>();


        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }

        int start = (page - 1) * size;
        Boolean next = false;

        try {

            log.info("======= 列表 获取 单个 用户的学习记录 =======");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus(uid, UserFavoriteRelation.TARGET_TYPE_TASK, UserFavoriteRelation.TYPE_VIEW_RECORD, UserFavoriteRelation.STATUS_ACTIVE, start, size);


            relationList = userFavoriteRelationService.getObjectsByIds(relationIds);
            taskIds = MyListUtil.getFieldValueListFromModelList(relationList, true, UserFavoriteRelation.class.getDeclaredField("targetId"));

            taskList = taskService.getObjectsByIds(taskIds);

            // periodId_alias   lessonId_alias   subjectId_alias
            List<Long> periodIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("periodId"), taskList);
            List<Long> lessonIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("lessonId"), taskList);
            List<Long> subjectIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("subjectId"), taskList);

            List<Period> periodList = periodService.getObjectsByIds(periodIdsR);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);

            Map<Long, String> periodId_alias = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("periodName"), periodList);
            Map<Long, String> lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);

            model.addAttribute("taskList", taskList);
            model.addAttribute("periodId_alias", periodId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);
            model.addAttribute("subjectId_alias", subjectId_alias);
            log.info("collection taskIds: " + taskIds);

            Map<String, Object> relationCountParams = DynamicUtil.getUserFavoriteRelationList(UserFavoriteRelation.TARGET_TYPE_TASK, UserFavoriteRelation.TYPE_VIEW_RECORD, true);
            List<Long> relationTotalList = userFavoriteRelationService.getIdsByDynamicCondition(UserFavoriteRelation.class, relationCountParams, 0, Integer.MAX_VALUE);

            Integer total = 0;
            if (DataUtils.isNotNullOrEmpty(relationTotalList)) {
                total = relationTotalList.get(0).intValue();
            }

            log.info(" total = " + total);
            Integer totalPage = (((total - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);


            if (totalPage > page) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("taskList", taskList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get collection task error ");
            model.addAttribute("code", -1);
        }

        return "/academy-course-service/lesson/json/userFavoriteLesson";

    }


}

