/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import zmq.Command;
import zmq.Ctx;
import zmq.Mailbox;
import zmq.ZObject;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;

public class IOThread
extends ZObject
implements IPollEvents,
Closeable {
    private final Mailbox mailbox;
    private final Poller.Handle mailboxHandle;
    private final Poller poller;
    private final String name;

    public IOThread(Ctx ctx, int tid) {
        super(ctx, tid);
        this.name = "iothread-" + tid;
        this.poller = new Poller(ctx, this.name);
        this.mailbox = new Mailbox(ctx, this.name, tid);
        SelectableChannel fd = this.mailbox.getFd();
        this.mailboxHandle = this.poller.addHandle(fd, this);
        this.poller.setPollIn(this.mailboxHandle);
    }

    public void start() {
        this.poller.start();
    }

    @Override
    public void close() throws IOException {
        this.poller.destroy();
        this.mailbox.close();
    }

    public void stop() {
        this.sendStop();
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public int getLoad() {
        return this.poller.getLoad();
    }

    @Override
    public void inEvent() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.process();
        }
    }

    @Override
    public void outEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timerEvent(int id) {
        throw new UnsupportedOperationException();
    }

    Poller getPoller() {
        assert (this.poller != null);
        return this.poller;
    }

    @Override
    protected void processStop() {
        this.poller.removeHandle(this.mailboxHandle);
        this.poller.stop();
    }
}

