/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.SpringObjenesis;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.CompositeUriComponentsContributor;
import org.springframework.web.method.support.UriComponentsContributor;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class MvcUriComponentsBuilder {
    public static final String MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME = "mvcUriComponentsContributor";
    private static final Log logger = LogFactory.getLog(MvcUriComponentsBuilder.class);
    private static final SpringObjenesis objenesis = new SpringObjenesis();
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final CompositeUriComponentsContributor defaultUriComponentsContributor = new CompositeUriComponentsContributor(new UriComponentsContributor[]{new PathVariableMethodArgumentResolver(), new RequestParamMethodArgumentResolver(false)});
    private final UriComponentsBuilder baseUrl;

    protected MvcUriComponentsBuilder(UriComponentsBuilder baseUrl) {
        Assert.notNull((Object)baseUrl, (String)"'baseUrl' is required");
        this.baseUrl = baseUrl;
    }

    public static MvcUriComponentsBuilder relativeTo(UriComponentsBuilder baseUrl) {
        return new MvcUriComponentsBuilder(baseUrl);
    }

    public static UriComponentsBuilder fromController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(null, controllerType);
    }

    public static UriComponentsBuilder fromController(UriComponentsBuilder builder, Class<?> controllerType) {
        builder = MvcUriComponentsBuilder.getBaseUrlToUse(builder);
        String mapping = MvcUriComponentsBuilder.getTypeRequestMapping(controllerType);
        return builder.path(mapping);
    }

    public static UriComponentsBuilder fromMethodName(Class<?> controllerType, String methodName, Object ... args) {
        Method method = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethodName(UriComponentsBuilder builder, Class<?> controllerType, String methodName, Object ... args) {
        Method method = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethodCall(Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, (Object)info);
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, arguments);
    }

    public static UriComponentsBuilder fromMethodCall(UriComponentsBuilder builder, Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, (Object)info);
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method, arguments);
    }

    public static MethodArgumentBuilder fromMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(null, mappingName);
    }

    public static MethodArgumentBuilder fromMappingName(UriComponentsBuilder builder, String name) {
        RequestMappingInfoHandlerMapping handlerMapping = MvcUriComponentsBuilder.getRequestMappingInfoHandlerMapping();
        List<HandlerMethod> handlerMethods = handlerMapping.getHandlerMethodsForMappingName(name);
        if (handlerMethods == null) {
            throw new IllegalArgumentException("Mapping mappingName not found: " + name);
        }
        if (handlerMethods.size() != 1) {
            throw new IllegalArgumentException("No unique match for mapping mappingName " + name + ": " + handlerMethods);
        }
        HandlerMethod handlerMethod = handlerMethods.get(0);
        Class controllerType = handlerMethod.getBeanType();
        Method method = handlerMethod.getMethod();
        return new MethodArgumentBuilder(builder, controllerType, method);
    }

    public static UriComponentsBuilder fromMethod(Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethod(UriComponentsBuilder baseUrl, Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(baseUrl, controllerType != null ? controllerType : method.getDeclaringClass(), method, args);
    }

    @Deprecated
    public static UriComponentsBuilder fromMethod(Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(null, method.getDeclaringClass(), method, args);
    }

    private static UriComponentsBuilder fromMethodInternal(UriComponentsBuilder baseUrl, Class<?> controllerType, Method method, Object ... args) {
        baseUrl = MvcUriComponentsBuilder.getBaseUrlToUse(baseUrl);
        String typePath = MvcUriComponentsBuilder.getTypeRequestMapping(controllerType);
        String methodPath = MvcUriComponentsBuilder.getMethodRequestMapping(method);
        String path = pathMatcher.combine(typePath, methodPath);
        baseUrl.path(path);
        UriComponents uriComponents = MvcUriComponentsBuilder.applyContributors(baseUrl, method, args);
        return UriComponentsBuilder.newInstance().uriComponents(uriComponents);
    }

    private static UriComponentsBuilder getBaseUrlToUse(UriComponentsBuilder baseUrl) {
        if (baseUrl != null) {
            return baseUrl.cloneBuilder();
        }
        return ServletUriComponentsBuilder.fromCurrentServletMapping();
    }

    private static String getTypeRequestMapping(Class<?> controllerType) {
        Assert.notNull(controllerType, (String)"'controllerType' must not be null");
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(controllerType, RequestMapping.class);
        if (requestMapping == null) {
            return "/";
        }
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty((Object[])paths) || StringUtils.isEmpty((Object)paths[0])) {
            return "/";
        }
        if (paths.length > 1 && logger.isWarnEnabled()) {
            logger.warn((Object)("Multiple paths on controller " + controllerType.getName() + ", using first one"));
        }
        return paths[0];
    }

    private static String getMethodRequestMapping(Method method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        if (requestMapping == null) {
            throw new IllegalArgumentException("No @RequestMapping on: " + method.toGenericString());
        }
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty((Object[])paths) || StringUtils.isEmpty((Object)paths[0])) {
            return "/";
        }
        if (paths.length > 1 && logger.isWarnEnabled()) {
            logger.warn((Object)("Multiple paths on method " + method.toGenericString() + ", using first one"));
        }
        return paths[0];
    }

    private static Method getMethod(Class<?> controllerType, final String methodName, final Object ... args) {
        ReflectionUtils.MethodFilter selector = new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                String name = method.getName();
                int argLength = method.getParameterTypes().length;
                return name.equals(methodName) && argLength == args.length;
            }
        };
        Set methods = MethodIntrospector.selectMethods(controllerType, (ReflectionUtils.MethodFilter)selector);
        if (methods.size() == 1) {
            return (Method)methods.iterator().next();
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(String.format("Found two methods named '%s' accepting arguments %s in controller %s: [%s]", methodName, Arrays.asList(args), controllerType.getName(), methods));
        }
        throw new IllegalArgumentException("No method named '" + methodName + "' with " + args.length + " arguments found in controller " + controllerType.getName());
    }

    private static UriComponents applyContributors(UriComponentsBuilder builder, Method method, Object ... args) {
        int argCount;
        int paramCount;
        CompositeUriComponentsContributor contributor = MvcUriComponentsBuilder.getConfiguredUriComponentsContributor();
        if (contributor == null) {
            logger.debug((Object)"Using default CompositeUriComponentsContributor");
            contributor = defaultUriComponentsContributor;
        }
        if ((paramCount = method.getParameterTypes().length) != (argCount = args.length)) {
            throw new IllegalArgumentException("Number of method parameters " + paramCount + " does not match number of argument values " + argCount);
        }
        final HashMap uriVars = new HashMap();
        for (int i = 0; i < paramCount; ++i) {
            SynthesizingMethodParameter param = new SynthesizingMethodParameter(method, i);
            param.initParameterNameDiscovery(parameterNameDiscoverer);
            contributor.contributeMethodArgument((MethodParameter)param, args[i], builder, uriVars);
        }
        return builder.build().expand(new UriComponents.UriTemplateVariables(){

            public Object getValue(String name) {
                return uriVars.containsKey(name) ? uriVars.get(name) : UriComponents.UriTemplateVariables.SKIP_VALUE;
            }
        });
    }

    private static CompositeUriComponentsContributor getConfiguredUriComponentsContributor() {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        if (wac == null) {
            return null;
        }
        try {
            return (CompositeUriComponentsContributor)wac.getBean(MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME, CompositeUriComponentsContributor.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No CompositeUriComponentsContributor bean with name 'mvcUriComponentsContributor'");
            }
            return null;
        }
    }

    private static RequestMappingInfoHandlerMapping getRequestMappingInfoHandlerMapping() {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        Assert.notNull((Object)wac, (String)"Cannot lookup handler method mappings without WebApplicationContext");
        try {
            return (RequestMappingInfoHandlerMapping)wac.getBean(RequestMappingInfoHandlerMapping.class);
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException("More than one RequestMappingInfoHandlerMapping beans found", ex);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new IllegalStateException("No RequestMappingInfoHandlerMapping bean", ex);
        }
    }

    private static WebApplicationContext getWebApplicationContext() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            logger.debug((Object)"No request bound to the current thread: is DispatcherSerlvet used?");
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (request == null) {
            logger.debug((Object)"Request bound to current thread is not an HttpServletRequest");
            return null;
        }
        String attributeName = DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE;
        WebApplicationContext wac = (WebApplicationContext)request.getAttribute(attributeName);
        if (wac == null) {
            logger.debug((Object)"No WebApplicationContext found: not in a DispatcherServlet request?");
            return null;
        }
        return wac;
    }

    public static <T> T on(Class<T> controllerType) {
        return MvcUriComponentsBuilder.controller(controllerType);
    }

    public static <T> T controller(Class<T> controllerType) {
        Assert.notNull(controllerType, (String)"'controllerType' must not be null");
        return MvcUriComponentsBuilder.initProxy(controllerType, new ControllerMethodInvocationInterceptor(controllerType));
    }

    private static <T> T initProxy(Class<?> type, ControllerMethodInvocationInterceptor interceptor) {
        if (type.isInterface()) {
            ProxyFactory factory = new ProxyFactory((Object)EmptyTargetSource.INSTANCE);
            factory.addInterface(type);
            factory.addInterface(MethodInvocationInfo.class);
            factory.addAdvice((Advice)interceptor);
            return (T)factory.getProxy();
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setInterfaces(new Class[]{MethodInvocationInfo.class});
        enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
        enhancer.setCallbackType(MethodInterceptor.class);
        Class proxyClass = enhancer.createClass();
        Object proxy = null;
        if (objenesis.isWorthTrying()) {
            try {
                proxy = objenesis.newInstance(proxyClass, enhancer.getUseCache());
            }
            catch (ObjenesisException ex) {
                logger.debug((Object)"Unable to instantiate controller proxy using Objenesis, falling back to regular construction", (Throwable)ex);
            }
        }
        if (proxy == null) {
            try {
                proxy = proxyClass.newInstance();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to instantiate controller proxy using Objenesis, and regular controller instantiation via default constructor fails as well", ex);
            }
        }
        ((Factory)proxy).setCallbacks(new Callback[]{interceptor});
        return (T)proxy;
    }

    public UriComponentsBuilder withController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(this.baseUrl, controllerType);
    }

    public UriComponentsBuilder withMethodName(Class<?> controllerType, String methodName, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodName(this.baseUrl, controllerType, methodName, args);
    }

    public UriComponentsBuilder withMethodCall(Object invocationInfo) {
        return MvcUriComponentsBuilder.fromMethodCall(this.baseUrl, invocationInfo);
    }

    public MethodArgumentBuilder withMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(this.baseUrl, mappingName);
    }

    public UriComponentsBuilder withMethod(Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethod(this.baseUrl, controllerType, method, args);
    }

    public static class MethodArgumentBuilder {
        private final Class<?> controllerType;
        private final Method method;
        private final Object[] argumentValues;
        private final UriComponentsBuilder baseUrl;

        public MethodArgumentBuilder(Class<?> controllerType, Method method) {
            this(null, controllerType, method);
        }

        public MethodArgumentBuilder(UriComponentsBuilder baseUrl, Class<?> controllerType, Method method) {
            Assert.notNull(controllerType, (String)"'controllerType' is required");
            Assert.notNull((Object)method, (String)"'method' is required");
            this.baseUrl = baseUrl != null ? baseUrl : MethodArgumentBuilder.initBaseUrl();
            this.controllerType = controllerType;
            this.method = method;
            this.argumentValues = new Object[method.getParameterTypes().length];
            for (int i = 0; i < this.argumentValues.length; ++i) {
                this.argumentValues[i] = null;
            }
        }

        @Deprecated
        public MethodArgumentBuilder(Method method) {
            this(method.getDeclaringClass(), method);
        }

        private static UriComponentsBuilder initBaseUrl() {
            ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentServletMapping();
            return UriComponentsBuilder.fromPath((String)builder.build().getPath());
        }

        public MethodArgumentBuilder arg(int index, Object value) {
            this.argumentValues[index] = value;
            return this;
        }

        public String build() {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build(false).encode().toUriString();
        }

        public String buildAndExpand(Object ... uriVars) {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build(false).expand(uriVars).encode().toString();
        }
    }

    public static interface MethodInvocationInfo {
        public Method getControllerMethod();

        public Object[] getArgumentValues();

        public Class<?> getControllerType();
    }

    private static class ControllerMethodInvocationInterceptor
    implements MethodInterceptor,
    org.aopalliance.intercept.MethodInterceptor {
        private static final Method getControllerMethod = ReflectionUtils.findMethod(MethodInvocationInfo.class, (String)"getControllerMethod");
        private static final Method getArgumentValues = ReflectionUtils.findMethod(MethodInvocationInfo.class, (String)"getArgumentValues");
        private static final Method getControllerType = ReflectionUtils.findMethod(MethodInvocationInfo.class, (String)"getControllerType");
        private Method controllerMethod;
        private Object[] argumentValues;
        private Class<?> controllerType;

        ControllerMethodInvocationInterceptor(Class<?> controllerType) {
            this.controllerType = controllerType;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) {
            if (getControllerMethod.equals(method)) {
                return this.controllerMethod;
            }
            if (getArgumentValues.equals(method)) {
                return this.argumentValues;
            }
            if (getControllerType.equals(method)) {
                return this.controllerType;
            }
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)obj, (Object[])args);
            }
            this.controllerMethod = method;
            this.argumentValues = args;
            Class<?> returnType = method.getReturnType();
            return Void.TYPE == returnType ? null : returnType.cast(MvcUriComponentsBuilder.initProxy(returnType, this));
        }

        public Object invoke(MethodInvocation inv) throws Throwable {
            return this.intercept(inv.getThis(), inv.getMethod(), inv.getArguments(), null);
        }
    }
}

