/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitResourceDetails;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ResourceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        String type = element.getAttribute("type");
        if ("authorization_code".equals(type)) {
            return AuthorizationCodeResourceDetails.class;
        }
        if ("implicit".equals(type)) {
            return ImplicitResourceDetails.class;
        }
        if ("client_credentials".equals(type)) {
            return ClientCredentialsResourceDetails.class;
        }
        if ("password".equals(type)) {
            return ResourceOwnerPasswordResourceDetails.class;
        }
        return BaseOAuth2ProtectedResourceDetails.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String scope;
        String useCurrentUri;
        String requireImmediateAuthorization;
        String userAuthorizationUri;
        String clientAuthenticationScheme;
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("An id must be supplied on a resource element.", (Object)element);
        }
        builder.addPropertyValue("id", (Object)id);
        String type = element.getAttribute("type");
        if (!StringUtils.hasText((String)type)) {
            type = "client_credentials";
        }
        builder.addPropertyValue("grantType", (Object)type);
        String accessTokenUri = element.getAttribute("access-token-uri");
        if (!StringUtils.hasText((String)accessTokenUri) && !"implicit".equals(type)) {
            parserContext.getReaderContext().error("An accessTokenUri must be supplied on a resource element of type " + type, (Object)element);
        }
        builder.addPropertyValue("accessTokenUri", (Object)accessTokenUri);
        String clientId = element.getAttribute("client-id");
        if (!StringUtils.hasText((String)clientId)) {
            parserContext.getReaderContext().error("An clientId must be supplied on a resource element", (Object)element);
        }
        builder.addPropertyValue("clientId", (Object)clientId);
        String clientSecret = element.getAttribute("client-secret");
        if (StringUtils.hasText((String)clientSecret)) {
            builder.addPropertyValue("clientSecret", (Object)clientSecret);
        }
        if (StringUtils.hasText((String)(clientAuthenticationScheme = element.getAttribute("client-authentication-scheme")))) {
            builder.addPropertyValue("clientAuthenticationScheme", (Object)clientAuthenticationScheme);
        }
        if (StringUtils.hasText((String)(userAuthorizationUri = element.getAttribute("user-authorization-uri")))) {
            if (this.needsUserAuthorizationUri(type)) {
                builder.addPropertyValue("userAuthorizationUri", (Object)userAuthorizationUri);
            } else {
                parserContext.getReaderContext().error("The " + type + " grant type does not accept an authorization URI", (Object)element);
            }
        } else if (this.needsUserAuthorizationUri(type)) {
            parserContext.getReaderContext().error("An authorization URI must be supplied for a resource of type " + type, (Object)element);
        }
        String preEstablishedRedirectUri = element.getAttribute("pre-established-redirect-uri");
        if (StringUtils.hasText((String)preEstablishedRedirectUri)) {
            builder.addPropertyValue("preEstablishedRedirectUri", (Object)preEstablishedRedirectUri);
        }
        if (StringUtils.hasText((String)(requireImmediateAuthorization = element.getAttribute("require-immediate-authorization")))) {
            builder.addPropertyValue("requireImmediateAuthorization", (Object)requireImmediateAuthorization);
        }
        if (StringUtils.hasText((String)(useCurrentUri = element.getAttribute("use-current-uri")))) {
            builder.addPropertyValue("useCurrentUri", (Object)useCurrentUri);
        }
        if (StringUtils.hasText((String)(scope = element.getAttribute("scope")))) {
            BeanDefinitionBuilder scopesBuilder = BeanDefinitionBuilder.genericBeanDefinition(StringListFactoryBean.class);
            scopesBuilder.addConstructorArgValue((Object)new TypedStringValue(scope));
            builder.addPropertyValue("scope", (Object)scopesBuilder.getBeanDefinition());
        }
        AuthenticationScheme btm = AuthenticationScheme.header;
        String bearerTokenMethod = element.getAttribute("authentication-scheme");
        if (StringUtils.hasText((String)bearerTokenMethod)) {
            btm = AuthenticationScheme.valueOf(bearerTokenMethod);
        }
        builder.addPropertyValue("authenticationScheme", (Object)btm);
        String bearerTokenName = element.getAttribute("token-name");
        if (!StringUtils.hasText((String)bearerTokenName)) {
            bearerTokenName = "access_token";
        }
        builder.addPropertyValue("tokenName", (Object)bearerTokenName);
        if (type.equals("password")) {
            String[] attributeNames;
            String[] stringArray = attributeNames = new String[]{"username", "password"};
            int n = attributeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                String attribute = element.getAttribute(attributeName);
                if (StringUtils.hasText((String)attribute)) {
                    builder.addPropertyValue(attributeName, (Object)attribute);
                } else {
                    parserContext.getReaderContext().error("A " + attributeName + " must be supplied on a resource element of type " + type, (Object)element);
                }
                ++n2;
            }
        }
    }

    private boolean needsUserAuthorizationUri(String type) {
        return type.equals("authorization_code") || type.equals("implicit");
    }

    public static class StringListFactoryBean
    implements FactoryBean<List<String>> {
        private final String commaSeparatedList;

        public StringListFactoryBean(String commaSeparatedList) {
            this.commaSeparatedList = commaSeparatedList;
        }

        public List<String> getObject() throws Exception {
            return new ArrayList<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)this.commaSeparatedList)));
        }

        public Class<?> getObjectType() {
            return List.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

