/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configurers;

import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenEndpointFilter;
import org.springframework.security.oauth2.provider.client.ClientDetailsUserDetailsService;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public final class AuthorizationServerSecurityConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
    private AccessDeniedHandler accessDeniedHandler = new OAuth2AccessDeniedHandler();
    private String realm = "oauth2/client";
    private boolean allowFormAuthenticationForClients = false;
    private String tokenKeyAccess = "denyAll()";
    private String checkTokenAccess = "denyAll()";

    public AuthorizationServerSecurityConfigurer allowFormAuthenticationForClients() {
        this.allowFormAuthenticationForClients = true;
        return this;
    }

    public AuthorizationServerSecurityConfigurer realm(String realm) {
        this.realm = realm;
        return this;
    }

    public AuthorizationServerSecurityConfigurer authenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
        return this;
    }

    public AuthorizationServerSecurityConfigurer tokenKeyAccess(String tokenKeyAccess) {
        this.tokenKeyAccess = tokenKeyAccess;
        return this;
    }

    public AuthorizationServerSecurityConfigurer checkTokenAccess(String checkTokenAccess) {
        this.checkTokenAccess = checkTokenAccess;
        return this;
    }

    public String getTokenKeyAccess() {
        return this.tokenKeyAccess;
    }

    public String getCheckTokenAccess() {
        return this.checkTokenAccess;
    }

    public void init(HttpSecurity http) throws Exception {
        this.registerDefaultAuthenticationEntryPoint(http);
        ((HttpSecurity)((HttpSecurity)http.userDetailsService((UserDetailsService)new ClientDetailsUserDetailsService(this.clientDetailsService())).securityContext().securityContextRepository((SecurityContextRepository)new NullSecurityContextRepository()).and()).csrf().disable()).httpBasic().realmName(this.realm);
    }

    private void registerDefaultAuthenticationEntryPoint(HttpSecurity http) {
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)http.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling == null) {
            return;
        }
        ContentNegotiationStrategy contentNegotiationStrategy = (ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher preferredMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML});
        preferredMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)this.postProcess(this.authenticationEntryPoint), (RequestMatcher)preferredMatcher);
    }

    public void configure(HttpSecurity http) throws Exception {
        this.frameworkEndpointHandlerMapping();
        if (this.allowFormAuthenticationForClients) {
            this.clientCredentialsTokenEndpointFilter(http);
        }
        http.exceptionHandling().accessDeniedHandler(this.accessDeniedHandler);
    }

    private ClientCredentialsTokenEndpointFilter clientCredentialsTokenEndpointFilter(HttpSecurity http) {
        ClientCredentialsTokenEndpointFilter clientCredentialsTokenEndpointFilter = new ClientCredentialsTokenEndpointFilter(this.frameworkEndpointHandlerMapping().getPath("/oauth/token"));
        clientCredentialsTokenEndpointFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        clientCredentialsTokenEndpointFilter = (ClientCredentialsTokenEndpointFilter)((Object)this.postProcess((Object)clientCredentialsTokenEndpointFilter));
        http.addFilterBefore((Filter)clientCredentialsTokenEndpointFilter, BasicAuthenticationFilter.class);
        return clientCredentialsTokenEndpointFilter;
    }

    private ClientDetailsService clientDetailsService() {
        return (ClientDetailsService)((HttpSecurity)this.getBuilder()).getSharedObject(ClientDetailsService.class);
    }

    private FrameworkEndpointHandlerMapping frameworkEndpointHandlerMapping() {
        return (FrameworkEndpointHandlerMapping)((Object)((HttpSecurity)this.getBuilder()).getSharedObject(FrameworkEndpointHandlerMapping.class));
    }
}

