/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.channel;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.integration.support.converter.MessageConverter;
import org.springframework.integration.support.converter.SimpleMessageConverter;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribableRedisChannel
extends AbstractMessageChannel
implements SubscribableChannel,
SmartLifecycle,
DisposableBean {
    private final RedisMessageListenerContainer container = new RedisMessageListenerContainer();
    private final RedisConnectionFactory connectionFactory;
    private final RedisTemplate redisTemplate;
    private final String topicName;
    private final MessageDispatcher dispatcher = new BroadcastingDispatcher(true);
    private volatile boolean initialized;
    private volatile Executor taskExecutor = new SimpleAsyncTaskExecutor();
    private volatile RedisSerializer<?> serializer = new StringRedisSerializer();
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();

    public SubscribableRedisChannel(RedisConnectionFactory connectionFactory, String topicName) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        Assert.hasText((String)topicName, (String)"'topicName' must not be empty");
        this.connectionFactory = connectionFactory;
        this.redisTemplate = new StringRedisTemplate(connectionFactory);
        this.topicName = topicName;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"'taskExecutor' must not be null");
        this.taskExecutor = taskExecutor;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
    }

    public boolean subscribe(MessageHandler handler) {
        return this.dispatcher.addHandler(handler);
    }

    public boolean unsubscribe(MessageHandler handler) {
        return this.dispatcher.removeHandler(handler);
    }

    protected boolean doSend(Message<?> message, long arg1) {
        this.redisTemplate.convertAndSend(this.topicName, this.messageConverter.fromMessage(message));
        return true;
    }

    public void onInit() throws Exception {
        if (this.initialized) {
            return;
        }
        super.onInit();
        if (this.messageConverter == null) {
            this.messageConverter = new SimpleMessageConverter();
        }
        this.container.setConnectionFactory(this.connectionFactory);
        if (!(this.taskExecutor instanceof ErrorHandlingTaskExecutor)) {
            MessagePublishingErrorHandler errorHandler = new MessagePublishingErrorHandler((ChannelResolver)new BeanFactoryChannelResolver(this.getBeanFactory()));
            this.taskExecutor = new ErrorHandlingTaskExecutor(this.taskExecutor, (ErrorHandler)errorHandler);
        }
        this.container.setTaskExecutor(this.taskExecutor);
        MessageListenerAdapter adapter = new MessageListenerAdapter((Object)new MessageListenerDelegate());
        adapter.setSerializer(this.serializer);
        adapter.afterPropertiesSet();
        this.container.addMessageListener((MessageListener)adapter, (Topic)new ChannelTopic(this.topicName));
        this.container.afterPropertiesSet();
        this.initialized = true;
    }

    public boolean isAutoStartup() {
        return this.container != null ? this.container.isAutoStartup() : false;
    }

    public int getPhase() {
        return this.container != null ? this.container.getPhase() : 0;
    }

    public boolean isRunning() {
        return this.container != null ? this.container.isRunning() : false;
    }

    public void start() {
        if (this.container != null) {
            this.container.start();
        }
    }

    public void stop() {
        this.connectionFactory.getConnection().discard();
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.container != null) {
            this.container.stop(callback);
        }
    }

    public void destroy() throws Exception {
        if (this.container != null) {
            this.container.destroy();
        }
    }

    private class MessageListenerDelegate {
        private MessageListenerDelegate() {
        }

        public void handleMessage(String s) {
            Message siMessage = SubscribableRedisChannel.this.messageConverter.toMessage((Object)s);
            try {
                SubscribableRedisChannel.this.dispatcher.dispatch(siMessage);
            }
            catch (MessageDispatchingException e) {
                String topicName = SubscribableRedisChannel.this.topicName;
                topicName = StringUtils.hasText((String)topicName) ? topicName : "unknown";
                throw new MessageDeliveryException(siMessage, e.getMessage() + " for redis-channel " + topicName + ".", (Throwable)e);
            }
        }
    }
}

