/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mail;

import java.util.Properties;
import javax.activation.MimeType;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@ConditionalOnClass(value={MimeMessage.class, MimeType.class})
@ConditionalOnProperty(prefix="spring.mail", value={"host"})
@ConditionalOnMissingBean(value={MailSender.class})
@EnableConfigurationProperties(value={MailProperties.class})
public class MailSenderAutoConfiguration {
    @Autowired
    MailProperties properties;

    @Bean
    public JavaMailSender mailSender() {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(this.properties.getHost());
        if (this.properties.getPort() != null) {
            sender.setPort(this.properties.getPort().intValue());
        }
        sender.setUsername(this.properties.getUsername());
        sender.setPassword(this.properties.getPassword());
        sender.setDefaultEncoding(this.properties.getDefaultEncoding());
        if (!this.properties.getProperties().isEmpty()) {
            Properties properties = new Properties();
            properties.putAll(this.properties.getProperties());
            sender.setJavaMailProperties(properties);
        }
        return sender;
    }
}

