/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.openqa.selenium.Cookie;

public class ReturnedCookie
extends Cookie {
    private final boolean isSecure;
    private boolean readyForValidation = true;

    public ReturnedCookie(String name, String value, String domain, String path, Date expiry, boolean isSecure, String currentUrl) {
        super(name, value, domain, path, expiry);
        this.isSecure = isSecure;
        this.validate();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    protected void validate() {
        if (!this.readyForValidation) {
            return;
        }
        super.validate();
    }

    public String toString() {
        return this.getName() + "=" + this.getValue() + ("".equals(this.getPath()) ? "" : ";path=" + this.getPath()) + (this.getExpiry() == null ? "" : ";expires=" + new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z").format(this.getExpiry())) + (this.isSecure ? ";secure;" : "");
    }
}

