/*
 * Decompiled with CFR 0.152.
 */
package ninja.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ninja.build.ArgumentTokenizer;
import ninja.build.DelayedRestartTrigger;
import ninja.build.RunClassInSeparateJvmMachine;
import ninja.build.WatchAndRestartMachine;
import ninja.maven.NinjaMavenPluginConstants;
import ninja.standalone.AutoStandalone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class NinjaRunMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter(property="ninja.skip", defaultValue="false", required=true)
    protected boolean skip;
    @Parameter(property="ninja.outputDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    protected String buildOutputDirectory;
    @Parameter(property="ninja.watchDirs", required=false)
    protected File[] watchDirs;
    @Parameter(property="ninja.watchAllClassPathDirs", defaultValue="false", required=true)
    protected boolean watchAllClassPathDirs;
    @Parameter(property="ninja.watchAllClassPathJars", defaultValue="false", required=true)
    protected boolean watchAllClassPathJars;
    @Parameter(property="ninja.includes", required=false)
    protected List<String> includes;
    @Parameter(property="ninja.excludes", required=false)
    protected List<String> excludes;
    @Parameter(property="ninja.useDefaultExcludes", defaultValue="true", required=true)
    protected boolean useDefaultExcludes;
    @Parameter(property="ninja.context", required=false)
    protected String context;
    @Deprecated
    protected String contextPath;
    @Parameter(property="ninja.mode", defaultValue="dev", required=false)
    protected String mode;
    @Parameter(property="ninja.port", required=false)
    protected Integer port;
    @Parameter(property="ninja.ssl.port", required=false)
    protected Integer sslPort;
    @Parameter(property="ninja.mainClass", required=false)
    protected String mainClass;
    @Parameter(property="ninja.jvmArgs", required=false)
    protected String jvmArgs;
    @Parameter(property="ninja.settleDownMillis", defaultValue="500", required=false)
    protected Long settleDownMillis;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag is on. Will not execute.");
            return;
        }
        this.initMojoFromUserSubmittedParameters();
        ArrayList<String> classpathItems = new ArrayList<String>();
        this.alertAndStopExecutionIfDirectoryWithCompiledClassesOfThisProjectDoesNotExist(this.buildOutputDirectory);
        classpathItems.add(this.buildOutputDirectory);
        for (Object artifact : this.project.getArtifacts()) {
            classpathItems.add(artifact.getFile().toString());
        }
        List<Artifact> allArtifactsFromNinjaStandaloneInPlugin = this.getAllArtifactsComingFromNinjaStandalone(this.pluginArtifacts);
        for (Artifact artifact : allArtifactsFromNinjaStandaloneInPlugin) {
            if (classpathItems.contains(artifact.getFile().toString())) continue;
            classpathItems.add(artifact.getFile().toString());
        }
        LinkedHashSet<String> includesAsSet = new LinkedHashSet<String>(this.includes != null ? this.includes : Collections.EMPTY_LIST);
        LinkedHashSet<String> excludesAsSet = new LinkedHashSet<String>(this.excludes != null ? this.excludes : Collections.EMPTY_LIST);
        LinkedHashSet<Path> directoriesToRecursivelyWatch = new LinkedHashSet<Path>();
        directoriesToRecursivelyWatch.add(FileSystems.getDefault().getPath(this.buildOutputDirectory, new String[0]).toAbsolutePath());
        if (this.watchDirs != null) {
            for (File watchDir : this.watchDirs) {
                directoriesToRecursivelyWatch.add(watchDir.toPath().toAbsolutePath());
            }
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            File file = artifact.getFile();
            if (file.isDirectory() && this.watchAllClassPathDirs) {
                directoriesToRecursivelyWatch.add(file.toPath().toAbsolutePath());
                continue;
            }
            if (!file.getName().endsWith(".jar") || !this.watchAllClassPathJars) continue;
            File parentDir = file.getParentFile();
            Path parentPath = parentDir.toPath().toAbsolutePath();
            String rulePrefix = parentDir.getAbsolutePath() + File.separator;
            rulePrefix = rulePrefix.replace("\\", "\\\\");
            if (!directoriesToRecursivelyWatch.contains(parentPath)) {
                excludesAsSet.add(rulePrefix + "(.*)$");
            }
            includesAsSet.add(rulePrefix + file.getName() + "$");
            directoriesToRecursivelyWatch.add(parentPath);
        }
        String mainClassToRun = this.mainClass != null ? this.mainClass : AutoStandalone.class.getCanonicalName();
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"Ninja will watch dirs:");
        for (Path path : directoriesToRecursivelyWatch) {
            this.getLog().info((CharSequence)(" " + path));
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Ninja will launch with:");
        this.getLog().info((CharSequence)("      context: " + (this.getContextPath() != null ? this.getContextPath() : "<default>")));
        this.getLog().info((CharSequence)("         mode: " + this.mode));
        this.getLog().info((CharSequence)("         port: " + (this.port != null ? this.port : "<default>")));
        this.getLog().info((CharSequence)("     ssl port: " + (this.sslPort != null ? this.sslPort : "<default>")));
        this.getLog().info((CharSequence)("    mainClass: " + mainClassToRun));
        this.getLog().info((CharSequence)("extra jvmArgs: " + (this.jvmArgs != null ? this.jvmArgs : "<none>")));
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        try {
            RunClassInSeparateJvmMachine machine = this.buildRunClassInSeparateJvmMachine("Standalone", mainClassToRun, classpathItems, this.buildJvmArguments(), this.project.getBasedir());
            DelayedRestartTrigger restartTrigger = this.buildDelayedRestartTrigger(machine);
            restartTrigger.setSettleDownMillis(this.settleDownMillis);
            restartTrigger.start();
            WatchAndRestartMachine watcher = this.buildWatchAndRestartMachine(directoriesToRecursivelyWatch, includesAsSet, excludesAsSet, restartTrigger);
            machine.restart();
            watcher.run();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected String getContextPath() {
        if (this.context != null) {
            return this.context;
        }
        return this.contextPath;
    }

    protected DelayedRestartTrigger buildDelayedRestartTrigger(RunClassInSeparateJvmMachine machine) {
        return new DelayedRestartTrigger(machine);
    }

    protected WatchAndRestartMachine buildWatchAndRestartMachine(Set<Path> directoriesToRecursivelyWatch, Set<String> includes, Set<String> excludes, DelayedRestartTrigger restartTrigger) throws IOException {
        return new WatchAndRestartMachine(directoriesToRecursivelyWatch, includes, excludes, restartTrigger);
    }

    protected RunClassInSeparateJvmMachine buildRunClassInSeparateJvmMachine(String name, String classNameWithMainToRun, List<String> classpath, List<String> jvmArguments, File mavenBaseDir) {
        return new RunClassInSeparateJvmMachine(name, classNameWithMainToRun, classpath, this.buildJvmArguments(), mavenBaseDir);
    }

    protected List<String> buildJvmArguments() {
        ArrayList<String> jvmArguments = new ArrayList<String>();
        String systemPropertyDevMode = "-Dninja.mode=" + this.mode;
        jvmArguments.add(systemPropertyDevMode);
        if (this.port != null) {
            String portSelection = "-Dninja.port=" + this.port;
            jvmArguments.add(portSelection);
        }
        if (this.sslPort != null) {
            String sslPortSelection = "-Dninja.ssl.port=" + this.sslPort;
            jvmArguments.add(sslPortSelection);
        }
        if (this.getContextPath() != null) {
            String contextPathSelection = "-Dninja.context=" + this.getContextPath();
            jvmArguments.add(contextPathSelection);
        }
        if (this.jvmArgs != null) {
            List<String> tokenizedArgs = ArgumentTokenizer.tokenize(this.jvmArgs, false);
            this.getLog().debug((CharSequence)"JVM arguments tokenizer results:");
            for (String s : tokenizedArgs) {
                this.getLog().debug((CharSequence)("argument: " + s + ""));
            }
            jvmArguments.addAll(tokenizedArgs);
        }
        return jvmArguments;
    }

    protected void initMojoFromUserSubmittedParameters() {
        if (this.useDefaultExcludes) {
            this.excludes.addAll(Arrays.asList(NinjaMavenPluginConstants.DEFAULT_EXCLUDE_PATTERNS));
        }
    }

    protected List<Artifact> getAllArtifactsComingFromNinjaStandalone(List<Artifact> artifacts) {
        ArrayList<Artifact> resultingArtifacts = new ArrayList<Artifact>();
        block0: for (Artifact artifact : artifacts) {
            for (String dependencyTrail : artifact.getDependencyTrail()) {
                if (!dependencyTrail.contains("ninja-standalone")) continue;
                resultingArtifacts.add(artifact);
                continue block0;
            }
        }
        return resultingArtifacts;
    }

    protected void alertAndStopExecutionIfDirectoryWithCompiledClassesOfThisProjectDoesNotExist(String directoryWithCompiledClassesOfThisProject) throws MojoExecutionException {
        File classesDir = null;
        if (directoryWithCompiledClassesOfThisProject != null) {
            classesDir = new File(directoryWithCompiledClassesOfThisProject);
        }
        if (classesDir == null || !classesDir.exists()) {
            this.getLog().error((CharSequence)("Directory with classes does not exist: " + directoryWithCompiledClassesOfThisProject));
            this.getLog().error((CharSequence)"Maybe running 'mvn compile'  before running 'mvn ninja:run' helps :)");
            throw new MojoExecutionException("Directory with classes does not exist: " + directoryWithCompiledClassesOfThisProject);
        }
    }
}

