/*
 * Decompiled with CFR 0.152.
 */
package ninja.build;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import ninja.build.DelayedRestartTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchAndRestartMachine
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WatchAndRestartMachine.class);
    private boolean shutdown;
    private final DelayedRestartTrigger restartTrigger;
    private final Set<String> includes;
    private final Set<String> excludes;
    private final WatchService watchService = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> mapOfWatchKeysToPaths = new HashMap<WatchKey, Path>();
    private final AtomicInteger takeCount;

    public WatchAndRestartMachine(Path directoryToRecursivelyWatch, Set<String> includes, Set<String> excludes, DelayedRestartTrigger restartTrigger) throws IOException {
        this(new HashSet<Path>(Arrays.asList(directoryToRecursivelyWatch)), includes, excludes, restartTrigger);
    }

    public WatchAndRestartMachine(Set<Path> directoriesToRecursivelyWatch, Set<String> includes, Set<String> excludes, DelayedRestartTrigger restartTrigger) throws IOException {
        this.includes = includes;
        this.excludes = excludes;
        this.restartTrigger = restartTrigger;
        this.takeCount = new AtomicInteger(0);
        for (Path path : directoriesToRecursivelyWatch) {
            this.registerAll(path);
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private void registerAll(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                WatchAndRestartMachine.this.register(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void register(Path path) throws IOException {
        WatchKey watchKey = path.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
        this.mapOfWatchKeysToPaths.put(watchKey, path);
    }

    @Override
    public void run() {
        while (true) {
            WatchKey watchKey;
            try {
                watchKey = this.watchService.take();
                this.takeCount.incrementAndGet();
            }
            catch (InterruptedException e) {
                if (!this.shutdown) {
                    log.error("Unexpectedly interrupted while waiting for take()", (Throwable)e);
                }
                return;
            }
            Path path = this.mapOfWatchKeysToPaths.get(watchKey);
            if (path == null) {
                log.error("WatchKey not recognized!!");
                continue;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                WatchEvent.Kind<?> watchEventKind = watchEvent.kind();
                if (watchEventKind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = watchEvent;
                Path name = (Path)ev.context();
                Path child = path.resolve(name);
                if (watchEventKind == StandardWatchEventKinds.ENTRY_MODIFY && !child.toFile().isDirectory()) {
                    this.handleNewOrModifiedFile("Modified", child);
                }
                if (watchEventKind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                if (!child.toFile().isDirectory()) {
                    this.handleNewOrModifiedFile("New", child);
                }
                try {
                    if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                catch (IOException e) {
                    log.error("Something fishy happened. Unable to register new dir for watching", (Throwable)e);
                }
            }
            boolean valid = watchKey.reset();
            if (valid) continue;
            this.mapOfWatchKeysToPaths.remove(watchKey);
            if (this.mapOfWatchKeysToPaths.isEmpty()) break;
        }
    }

    public void handleNewOrModifiedFile(String newOrMod, Path path) {
        String f = path.toFile().getAbsolutePath();
        log.debug("{} file detected: {}", (Object)newOrMod, (Object)f);
        RuleMatch match = WatchAndRestartMachine.matchRule(this.includes, this.excludes, f);
        log.debug(" matched rule: type={}, pattern={}, proceed={}", new Object[]{match.type, match.pattern, match.proceed});
        if (match.proceed) {
            log.debug(" will trigger restart", (Object)newOrMod, (Object)f);
            this.restartTrigger.trigger();
        } else {
            log.debug(" will not trigger restart");
        }
    }

    public static RuleMatch matchRule(Set<String> includes, Set<String> excludes, String string) {
        if (includes != null) {
            for (String regex : includes) {
                if (!string.matches(regex)) continue;
                return new RuleMatch(RuleType.include, regex, true);
            }
        }
        if (excludes != null) {
            for (String regex : excludes) {
                if (!string.matches(regex)) continue;
                return new RuleMatch(RuleType.exclude, regex, false);
            }
        }
        return new RuleMatch(RuleType.none, "", true);
    }

    public static boolean checkIfWouldBeExcluded(Set<String> patterns, String string) {
        return !WatchAndRestartMachine.matchRule(null, patterns, (String)string).proceed;
    }

    public static class RuleMatch {
        final RuleType type;
        final String pattern;
        final boolean proceed;

        public RuleMatch(RuleType type, String pattern, boolean proceed) {
            this.type = type;
            this.pattern = pattern;
            this.proceed = proceed;
        }
    }

    public static enum RuleType {
        none,
        include,
        exclude;

    }
}

