/*
 * Decompiled with CFR 0.152.
 */
package ninja.build;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.listener.ProcessListener;

public class RunClassInSeparateJvmMachine {
    private static final Logger log = LoggerFactory.getLogger(RunClassInSeparateJvmMachine.class);
    private final String name;
    private OutputStream output;
    StartedProcess activeProcess;
    private final AtomicBoolean restarting;
    private final String classNameWithMainToRun;
    private final String classpath;
    private final List<String> jvmArguments;
    private final File mavenBaseDir;

    public RunClassInSeparateJvmMachine(String name, String classNameWithMainToRun, List<String> classpath, List<String> jvmArguments, File mavenBaseDir) {
        this(name, classNameWithMainToRun, StringUtils.join(classpath, (String)File.pathSeparator), jvmArguments, mavenBaseDir);
    }

    public RunClassInSeparateJvmMachine(String name, String classNameWithMainToRun, String classpath, List<String> jvmArguments, File mavenBaseDir) {
        this.name = name;
        this.output = System.out;
        this.classNameWithMainToRun = classNameWithMainToRun;
        this.classpath = classpath;
        this.jvmArguments = jvmArguments;
        this.mavenBaseDir = mavenBaseDir;
        this.restarting = new AtomicBoolean(false);
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public StartedProcess getActiveProcess() {
        return this.activeProcess;
    }

    public void setActiveProcess(StartedProcess activeProcess) {
        this.activeProcess = activeProcess;
    }

    public synchronized void restart() {
        this.restarting.set(true);
        try {
            if (this.activeProcess != null) {
                log.debug("Attempting to destroy previous {} process", (Object)this.name);
                this.activeProcess.getProcess().destroy();
                log.debug("Waiting for previous {} process to terminate", (Object)this.name);
                ProcessResult processResult = (ProcessResult)this.activeProcess.getFuture().get();
            }
            log.debug("Starting new {}", (Object)this.name);
            this.activeProcess = this.startProcess();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error("Something fishy happenend. Unable to cleanly restart {}!", (Object)this.name, (Object)e);
            log.error("You'll probably need to restart maven?");
        }
        finally {
            this.restarting.set(false);
        }
    }

    StartedProcess startProcess() throws IOException {
        ProcessExecutor processExecutor = this.buildProcessExecutor();
        return processExecutor.start();
    }

    ProcessExecutor buildProcessExecutor() {
        ArrayList<String> commandLine = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        commandLine.add(javaBin);
        commandLine.addAll(this.jvmArguments);
        commandLine.add("-cp");
        commandLine.add(this.classpath);
        commandLine.add(this.classNameWithMainToRun);
        return new ProcessExecutor(commandLine).directory(this.mavenBaseDir).destroyOnExit().addListener(new ProcessListener(){

            public void afterStop(Process process) {
                if (!RunClassInSeparateJvmMachine.this.restarting.get()) {
                    log.error("JVM process for {} terminated (next file change will attempt to restart it)", (Object)RunClassInSeparateJvmMachine.this.name);
                }
            }
        }).redirectErrorStream(true).redirectOutput(this.output);
    }
}

