/*
 * Decompiled with CFR 0.152.
 */
package ninja.build;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import ninja.build.RunClassInSeparateJvmMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedRestartTrigger
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DelayedRestartTrigger.class);
    private boolean shutdown = false;
    private final AtomicInteger restartCount;
    private final AtomicInteger accumulatedTriggerCount;
    private final ReentrantLock restartLock;
    private final Condition restartRequested;
    private long settleDownMillis = 500L;
    private final RunClassInSeparateJvmMachine runClassInSeparateJvmMachine;

    public DelayedRestartTrigger(RunClassInSeparateJvmMachine runClassInSeparateJvmMachine) {
        this.setDaemon(true);
        this.setName("DelayedRestartTrigger");
        this.restartCount = new AtomicInteger(0);
        this.accumulatedTriggerCount = new AtomicInteger(0);
        this.restartLock = new ReentrantLock();
        this.restartRequested = this.restartLock.newCondition();
        this.runClassInSeparateJvmMachine = runClassInSeparateJvmMachine;
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public int getRestartCount() {
        return this.restartCount.get();
    }

    public int getAccumulatedTriggerCount() {
        return this.accumulatedTriggerCount.get();
    }

    public long getSettleDownMillis() {
        return this.settleDownMillis;
    }

    public void setSettleDownMillis(long settleDownMillis) {
        this.settleDownMillis = settleDownMillis;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.restartLock.lock();
                try {
                    if (this.accumulatedTriggerCount.get() <= 0) {
                        this.restartRequested.await();
                    }
                    this.restartCount.incrementAndGet();
                }
                finally {
                    this.restartLock.unlock();
                }
                log.info("------------------------------------------------------------------------");
                log.info("Restart process starting...");
                int totalTriggerCount = 0;
                do {
                    log.info("Delaying restart for " + this.settleDownMillis + " ms to wait for file changes to settle");
                    totalTriggerCount += this.accumulatedTriggerCount.getAndSet(0);
                    try {
                        Thread.sleep(this.settleDownMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.accumulatedTriggerCount.get() != 0);
                log.info("Restarting SuperDevMode (" + totalTriggerCount + " file change(s) detected)");
                log.info("------------------------------------------------------------------------");
                this.accumulatedTriggerCount.set(0);
                this.runClassInSeparateJvmMachine.restart();
            }
            catch (InterruptedException e) {
                if (this.shutdown) break;
                log.error("Unexpected thread interrupt (maybe you are shutting down Maven?)", (Throwable)e);
                break;
            }
        }
    }

    public void trigger() {
        this.restartLock.lock();
        try {
            this.accumulatedTriggerCount.incrementAndGet();
            this.restartRequested.signal();
        }
        finally {
            this.restartLock.unlock();
        }
    }
}

