/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransaction
implements Transaction {
    private final Logger logger = LoggerFactory.getLogger(Transaction.class);
    protected final TransactionManager transactionManager;
    private final AtomicLong extendsCount = new AtomicLong();
    private final List<Object> registeredNew = new ArrayList<Object>();
    private Transaction.Status status = Transaction.Status.OPEN;
    protected Transaction.Type type = Transaction.Type.READ_WRITE;

    protected AbstractTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void rollback() {
        long extensions = this.extendsCount.get();
        this.logger.debug("Thread {}: Rollback transaction extent: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
        if (extensions == 0L) {
            if (this.transactionManager != null) {
                this.transactionManager.rollback(this);
                this.status = Transaction.Status.ROLLEDBACK;
                this.logger.debug("Thread {}: Rolled back", (Object)Thread.currentThread().getId());
            }
        } else {
            this.logger.debug("Thread {}: Rollback deferred", (Object)Thread.currentThread().getId());
            this.status = Transaction.Status.ROLLBACK_PENDING;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit() {
        long extensions = this.extendsCount.get();
        this.logger.debug("Thread {}: Commit transaction extent: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
        if (extensions == 0L) {
            if (!this.canCommit()) throw new TransactionException("Transaction cannot commit");
            if (this.transactionManager == null) return;
            this.transactionManager.commit(this);
            this.status = Transaction.Status.COMMITTED;
            this.logger.debug("Thread {}: Committed", (Object)Thread.currentThread().getId());
            return;
        } else {
            if (this.status == Transaction.Status.ROLLBACK_PENDING) {
                throw new TransactionException("Transaction cannot commit: rollback pending");
            }
            this.logger.debug("Thread {}: Commit deferred", (Object)Thread.currentThread().getId());
            this.status = Transaction.Status.COMMIT_PENDING;
        }
    }

    @Override
    public boolean canCommit() {
        return this.status == Transaction.Status.OPEN || this.status == Transaction.Status.PENDING || this.status == Transaction.Status.COMMIT_PENDING;
    }

    public void extend(Transaction.Type type) {
        if (this.type != type) {
            throw new TransactionException("Incompatible transaction type specified: must be '" + (Object)((Object)this.type) + "'");
        }
        long extensions = this.extendsCount.incrementAndGet();
        this.logger.debug("Thread {}: Transaction extended: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
    }

    @Override
    public final Transaction.Status status() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.type == Transaction.Type.READ_ONLY;
    }

    @Override
    public Transaction.Type type() {
        return this.type;
    }

    @Override
    public void close() {
        long extensions = this.extendsCount.get();
        this.logger.debug("Thread {}: Close transaction extent: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
        if (extensions == 0L) {
            this.logger.debug("Thread {}: Closing transaction", (Object)Thread.currentThread().getId());
            if (this.status == Transaction.Status.ROLLBACK_PENDING) {
                this.rollback();
            } else if (this.status == Transaction.Status.COMMIT_PENDING) {
                this.commit();
            } else if (this.status == Transaction.Status.PENDING || this.status == Transaction.Status.OPEN) {
                this.rollback();
            }
            this.status = Transaction.Status.CLOSED;
        } else {
            this.extendsCount.getAndDecrement();
            this.logger.debug("Thread {}: Close deferred", (Object)Thread.currentThread().getId());
        }
    }

    public long extensions() {
        return this.extendsCount.get();
    }

    public void registerNew(Object persisted) {
        this.registeredNew.add(persisted);
    }

    public List<Object> registeredNew() {
        return this.registeredNew;
    }

    public void reOpen() {
        this.status = Transaction.Status.OPEN;
    }
}

