/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

abstract class TransactionStartingMessage
implements Message {
    private static final String BOOKMARKS_METADATA_KEY = "bookmarks";
    private static final String TX_TIMEOUT_METADATA_KEY = "tx_timeout";
    private static final String TX_METADATA_METADATA_KEY = "tx_metadata";
    final Map<String, Value> metadata;

    TransactionStartingMessage(Bookmarks bookmarks, Duration txTimeout, Map<String, Value> txMetadata) {
        this.metadata = TransactionStartingMessage.buildMetadata(bookmarks, txTimeout, txMetadata);
    }

    public final Map<String, Value> metadata() {
        return this.metadata;
    }

    private static Map<String, Value> buildMetadata(Bookmarks bookmarks, Duration txTimeout, Map<String, Value> txMetadata) {
        boolean txMetadataPresent;
        boolean bookmarksPresent = bookmarks != null && !bookmarks.isEmpty();
        boolean txTimeoutPresent = txTimeout != null;
        boolean bl = txMetadataPresent = txMetadata != null && !txMetadata.isEmpty();
        if (!(bookmarksPresent || txTimeoutPresent || txMetadataPresent)) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> result = Iterables.newHashMapWithSize(3);
        if (bookmarksPresent) {
            result.put(BOOKMARKS_METADATA_KEY, Values.value(bookmarks.values()));
        }
        if (txTimeoutPresent) {
            result.put(TX_TIMEOUT_METADATA_KEY, Values.value(txTimeout.toMillis()));
        }
        if (txMetadataPresent) {
            result.put(TX_METADATA_METADATA_KEY, Values.value(txMetadata));
        }
        return result;
    }
}

