/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.InternalPair;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.MapAccessor;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.util.Function;
import org.neo4j.driver.v1.util.Pair;

public final class Extract {
    private Extract() {
        throw new UnsupportedOperationException();
    }

    public static List<Value> list(Value[] values) {
        switch (values.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(values[0]);
            }
        }
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static <T> List<T> list(Value[] data, Function<Value, T> mapFunction) {
        int size = data.length;
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(mapFunction.apply(data[0]));
            }
        }
        ArrayList<T> result = new ArrayList<T>(size);
        for (Value value : data) {
            result.add(mapFunction.apply(value));
        }
        return Collections.unmodifiableList(result);
    }

    public static Map<String, Value> map(Map<String, Value> data) {
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(data);
    }

    public static <T> Map<String, T> map(Map<String, Value> data, Function<Value, T> mapFunction) {
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = data.size();
        if (size == 1) {
            Map.Entry<String, Value> head = data.entrySet().iterator().next();
            return Collections.singletonMap(head.getKey(), mapFunction.apply(head.getValue()));
        }
        LinkedHashMap<String, T> map = Iterables.newLinkedHashMapWithSize(size);
        for (Map.Entry<String, Value> entry : data.entrySet()) {
            map.put(entry.getKey(), mapFunction.apply(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> Map<String, T> map(Record record, Function<Value, T> mapFunction) {
        int size = record.size();
        switch (size) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(record.keys().get(0), mapFunction.apply(record.get(0)));
            }
        }
        LinkedHashMap<String, T> map = Iterables.newLinkedHashMapWithSize(size);
        List<String> keys = record.keys();
        for (int i = 0; i < size; ++i) {
            map.put(keys.get(i), mapFunction.apply(record.get(i)));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <V> Iterable<Pair<String, V>> properties(MapAccessor map, Function<Value, V> mapFunction) {
        int size = map.size();
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                String key = map.keys().iterator().next();
                Value value = map.get(key);
                return Collections.singletonList(InternalPair.of(key, mapFunction.apply(value)));
            }
        }
        ArrayList<Pair<String, V>> list = new ArrayList<Pair<String, V>>(size);
        for (String key : map.keys()) {
            Value value = map.get(key);
            list.add(InternalPair.of(key, mapFunction.apply(value)));
        }
        return Collections.unmodifiableList(list);
    }

    public static <V> List<Pair<String, V>> fields(Record map, Function<Value, V> mapFunction) {
        int size = map.keys().size();
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                String key = map.keys().iterator().next();
                Value value = map.get(key);
                return Collections.singletonList(InternalPair.of(key, mapFunction.apply(value)));
            }
        }
        ArrayList<Pair<String, V>> list = new ArrayList<Pair<String, V>>(size);
        List<String> keys = map.keys();
        for (int i = 0; i < size; ++i) {
            String key = keys.get(i);
            Value value = map.get(i);
            list.add(InternalPair.of(key, mapFunction.apply(value)));
        }
        return Collections.unmodifiableList(list);
    }

    public static void assertParameter(Object value) {
        if (value instanceof Node || value instanceof NodeValue) {
            throw new ClientException("Nodes can't be used as parameters.");
        }
        if (value instanceof Relationship || value instanceof RelationshipValue) {
            throw new ClientException("Relationships can't be used as parameters.");
        }
        if (value instanceof Path || value instanceof PathValue) {
            throw new ClientException("Paths can't be used as parameters.");
        }
    }
}

