/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.plugin.Jetty6PluginWebApplication;
import org.mortbay.jetty.plugin.util.JettyPluginServer;
import org.mortbay.jetty.plugin.util.JettyPluginWebApplication;
import org.mortbay.jetty.plugin.util.PluginLog;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.resource.Resource;

public class Jetty6PluginServer
implements JettyPluginServer {
    public static int DEFAULT_PORT = 8080;
    public static int DEFAULT_MAX_IDLE_TIME = 30000;
    private Server server = new Server();
    private ContextHandlerCollection contexts;
    HandlerCollection handlers;
    private RequestLogHandler requestLogHandler;
    private DefaultHandler defaultHandler;
    private RequestLog requestLog;

    public Jetty6PluginServer() {
        this.server.setStopAtShutdown(true);
        Resource.setDefaultUseCaches((boolean)false);
    }

    public void setConnectors(Object[] connectors) {
        if (connectors == null || connectors.length == 0) {
            return;
        }
        for (int i = 0; i < connectors.length; ++i) {
            Connector connector = (Connector)connectors[i];
            PluginLog.getLog().debug((CharSequence)("Setting Connector: " + connector.getClass().getName() + " on port " + connector.getPort()));
            this.server.addConnector(connector);
        }
    }

    public Object[] getConnectors() {
        return this.server.getConnectors();
    }

    public void setUserRealms(Object[] realms) throws Exception {
        if (realms == null) {
            return;
        }
        for (int i = 0; i < realms.length; ++i) {
            this.server.addUserRealm((UserRealm)realms[i]);
        }
    }

    public Object[] getUserRealms() {
        return this.server.getUserRealms();
    }

    public void setRequestLog(Object requestLog) {
        this.requestLog = (RequestLog)requestLog;
    }

    public Object getRequestLog() {
        return this.requestLog;
    }

    public void start() throws Exception {
        PluginLog.getLog().info((CharSequence)("Starting jetty " + this.server.getClass().getPackage().getImplementationVersion() + " ..."));
        this.server.start();
    }

    public Object getProxiedObject() {
        return this.server;
    }

    public void addWebApplication(JettyPluginWebApplication webapp) throws Exception {
        this.contexts.addHandler((Handler)webapp.getProxiedObject());
    }

    public void configureHandlers() throws Exception {
        this.defaultHandler = new DefaultHandler();
        this.requestLogHandler = new RequestLogHandler();
        if (this.requestLog != null) {
            this.requestLogHandler.setRequestLog(this.requestLog);
        }
        this.contexts = (ContextHandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
            this.handlers = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
            if (this.handlers == null) {
                this.handlers = new HandlerCollection();
                this.server.setHandler((Handler)this.handlers);
                this.handlers.setHandlers(new Handler[]{this.contexts, this.defaultHandler, this.requestLogHandler});
            } else {
                this.handlers.addHandler((Handler)this.contexts);
            }
        }
    }

    public Object createDefaultConnector(String portnum) throws Exception {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector = new SelectChannelConnector();
        int port = portnum == null || portnum.equals("") ? DEFAULT_PORT : Integer.parseInt(portnum.trim());
        connector.setPort(port);
        connector.setMaxIdleTime(DEFAULT_MAX_IDLE_TIME);
        return connector;
    }

    public JettyPluginWebApplication createWebApplication() throws Exception {
        return new Jetty6PluginWebApplication();
    }

    public void join() throws Exception {
        this.server.getThreadPool().join();
    }
}

