/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.reflection.runtime.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QNameMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    transient Entry<V>[] table = new Entry[16];
    transient int size;
    private int threshold = 12;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Set<Entry<V>> entrySet = null;

    public void put(String string, String string2, V v) {
        assert (string2 != null);
        assert (string != null);
        assert (string2 == string2.intern());
        assert (string == string.intern());
        int n = QNameMap.hash(string2);
        int n2 = QNameMap.indexFor(n, this.table.length);
        Entry<V> entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && string2 == entry.localName && string == entry.nsUri) {
                entry.value = v;
                return;
            }
            entry = entry.next;
        }
        this.addEntry(n, string, string2, v, n2);
    }

    public void put(QName qName, V v) {
        this.put(qName.getNamespaceURI(), qName.getLocalPart(), v);
    }

    public void put(Name name, V v) {
        this.put(name.nsUri, name.localName, v);
    }

    public V get(String string, String string2) {
        Entry<V> entry = this.getEntry(string, string2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public V get(QName qName) {
        return this.get(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public int size() {
        return this.size;
    }

    public QNameMap<V> putAll(QNameMap<? extends V> qNameMap) {
        int n = qNameMap.size();
        if (n == 0) {
            return this;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = n;
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Entry<V> entry : qNameMap.entrySet()) {
            this.put(entry.nsUri, entry.localName, entry.getValue());
        }
        return this;
    }

    private static int hash(String string) {
        int n = string.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    private void addEntry(int n, String string, String string2, V v, int n2) {
        Entry<V> entry = this.table[n2];
        this.table[n2] = new Entry<V>(n, string, string2, v, entry);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void resize(int n) {
        Entry<V>[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = n;
    }

    private void transfer(Entry<V>[] entryArray) {
        Entry<V>[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry<V> entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = QNameMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    public Entry<V> getOne() {
        for (Entry<V> entry : this.table) {
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public Collection<QName> keySet() {
        HashSet<QName> hashSet = new HashSet<QName>();
        for (Entry<V> entry : this.entrySet()) {
            hashSet.add(entry.createQName());
        }
        return hashSet;
    }

    public boolean containsKey(String string, String string2) {
        return this.getEntry(string, string2) != null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set<Entry<V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    private Iterator<Entry<V>> newEntryIterator() {
        return new EntryIterator();
    }

    private Entry<V> getEntry(String string, String string2) {
        assert (string == string.intern());
        assert (string2 == string2.intern());
        int n = QNameMap.hash(string2);
        int n2 = QNameMap.indexFor(n, this.table.length);
        Entry<V> entry = this.table[n2];
        while (entry != null && (string2 != entry.localName || string != entry.nsUri)) {
            entry = entry.next;
        }
        return entry;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (Entry<V> entry : this.entrySet()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append('[');
            stringBuilder.append(entry);
            stringBuilder.append(']');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return QNameMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            Entry entry2 = QNameMap.this.getEntry(entry.nsUri, entry.localName);
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return QNameMap.this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends HashIterator<Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public Entry<V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry<V> {
        public final String nsUri;
        public final String localName;
        V value;
        final int hash;
        Entry<V> next;

        Entry(int n, String string, String string2, V v, Entry<V> entry) {
            this.value = v;
            this.next = entry;
            this.nsUri = string;
            this.localName = string2;
            this.hash = n;
        }

        public QName createQName() {
            return new QName(this.nsUri, this.localName);
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public boolean equals(Object object) {
            V v;
            V v2;
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            String string = this.nsUri;
            String string2 = entry.nsUri;
            String string3 = this.localName;
            String string4 = entry.localName;
            return (string == string2 || string != null && string.equals(string2) && (string3 == string4 || string3 != null && string3.equals(string4))) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        public int hashCode() {
            return this.localName.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return '\"' + this.nsUri + "\",\"" + this.localName + "\"=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<V> next;
        int index;

        HashIterator() {
            Entry<V>[] entryArray = QNameMap.this.table;
            int n = entryArray.length;
            Entry entry = null;
            if (QNameMap.this.size != 0) {
                while (n > 0 && (entry = entryArray[--n]) == null) {
                }
            }
            this.next = entry;
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<V> nextEntry() {
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry<V>[] entryArray = QNameMap.this.table;
            int n = this.index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this.index = n;
            this.next = entry2;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

