/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.unmarshaller;

import com.sun.istack.Nullable;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.reflection.impl.DatatypeConverterImpl;
import org.jvnet.jaxb.reflection.runtime.JaxBeanInfo;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Loader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Messages;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.TagName;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.UnmarshallingContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XsiTypeLoader
extends Loader {
    private final JaxBeanInfo defaultBeanInfo;

    public XsiTypeLoader(JaxBeanInfo jaxBeanInfo) {
        super(true);
        this.defaultBeanInfo = jaxBeanInfo;
    }

    public void startElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        Loader loader;
        JaxBeanInfo jaxBeanInfo = XsiTypeLoader.parseXsiType(state, tagName, this.defaultBeanInfo);
        if (jaxBeanInfo == null) {
            jaxBeanInfo = this.defaultBeanInfo;
        }
        state.loader = loader = jaxBeanInfo.getLoader(null, false);
        loader.startElement(state, tagName);
    }

    static JaxBeanInfo parseXsiType(UnmarshallingContext.State state, TagName tagName, @Nullable JaxBeanInfo jaxBeanInfo) throws SAXException {
        UnmarshallingContext unmarshallingContext = state.getContext();
        JaxBeanInfo jaxBeanInfo2 = null;
        Attributes attributes = tagName.atts;
        int n = attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (n >= 0) {
            String string = attributes.getValue(n);
            QName qName = DatatypeConverterImpl._parseQName(string, unmarshallingContext);
            if (qName == null) {
                XsiTypeLoader.reportError(Messages.NOT_A_QNAME.format(string), true);
            } else {
                if (jaxBeanInfo != null && jaxBeanInfo.getTypeNames().contains(qName)) {
                    return jaxBeanInfo;
                }
                jaxBeanInfo2 = unmarshallingContext.getJAXBContext().getGlobalType(qName);
                if (jaxBeanInfo2 == null) {
                    String string2 = unmarshallingContext.getJAXBContext().getNearestTypeName(qName);
                    if (string2 != null) {
                        XsiTypeLoader.reportError(Messages.UNRECOGNIZED_TYPE_NAME_MAYBE.format(qName, string2), true);
                    } else {
                        XsiTypeLoader.reportError(Messages.UNRECOGNIZED_TYPE_NAME.format(qName), true);
                    }
                }
            }
        }
        return jaxBeanInfo2;
    }
}

