/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.unmarshaller;

import org.jvnet.jaxb.reflection.impl.DatatypeConverterImpl;
import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Discarder;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Loader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.ProxyLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.TagName;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.UnmarshallingContext;
import org.xml.sax.SAXException;

public class XsiNilLoader
extends ProxyLoader {
    private final Loader defaultLoader;

    public XsiNilLoader(Loader defaultLoader) {
        this.defaultLoader = defaultLoader;
        assert (defaultLoader != null);
    }

    protected Loader selectLoader(UnmarshallingContext.State state, TagName ea) throws SAXException {
        String value;
        int idx = ea.atts.getIndex("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (idx != -1 && DatatypeConverterImpl._parseBoolean(value = ea.atts.getValue(idx))) {
            this.onNil(state);
            return Discarder.INSTANCE;
        }
        return this.defaultLoader;
    }

    protected void onNil(UnmarshallingContext.State state) throws SAXException {
    }

    public static final class Array
    extends XsiNilLoader {
        public Array(Loader core) {
            super(core);
        }

        protected void onNil(UnmarshallingContext.State state) {
            state.target = null;
        }
    }

    public static final class Single
    extends XsiNilLoader {
        private final Accessor acc;

        public Single(Loader l, Accessor acc) {
            super(l);
            this.acc = acc;
        }

        protected void onNil(UnmarshallingContext.State state) throws SAXException {
            try {
                this.acc.set(state.prev.target, null);
            }
            catch (AccessorException e) {
                Single.handleGenericException(e, true);
            }
        }
    }
}

