/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.reflect;

import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.ListIterator;
import org.jvnet.jaxb.reflection.runtime.reflect.Lister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveArrayListerInteger<BeanT>
extends Lister<BeanT, int[], Integer, IntegerArrayPack> {
    private PrimitiveArrayListerInteger() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Integer.TYPE, new PrimitiveArrayListerInteger());
    }

    @Override
    public ListIterator<Integer> iterator(final int[] nArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Integer>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < nArray.length;
            }

            @Override
            public Integer next() {
                return nArray[this.idx++];
            }
        };
    }

    @Override
    public IntegerArrayPack startPacking(BeanT BeanT, Accessor<BeanT, int[]> accessor) {
        return new IntegerArrayPack();
    }

    @Override
    public void addToPack(IntegerArrayPack integerArrayPack, Integer n) {
        integerArrayPack.add(n);
    }

    @Override
    public void endPacking(IntegerArrayPack integerArrayPack, BeanT BeanT, Accessor<BeanT, int[]> accessor) throws AccessorException {
        accessor.set(BeanT, integerArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, int[]> accessor) throws AccessorException {
        accessor.set(BeanT, new int[0]);
    }

    static final class IntegerArrayPack {
        int[] buf = new int[16];
        int size;

        IntegerArrayPack() {
        }

        void add(Integer n) {
            if (this.buf.length == this.size) {
                int[] nArray = new int[this.buf.length * 2];
                System.arraycopy(this.buf, 0, nArray, 0, this.buf.length);
                this.buf = nArray;
            }
            this.buf[this.size++] = n;
        }

        int[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            int[] nArray = new int[this.size];
            System.arraycopy(this.buf, 0, nArray, 0, this.size);
            return nArray;
        }
    }
}

