/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.reflect;

import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.ListIterator;
import org.jvnet.jaxb.reflection.runtime.reflect.Lister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveArrayListerFloat<BeanT>
extends Lister<BeanT, float[], Float, FloatArrayPack> {
    private PrimitiveArrayListerFloat() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Float.TYPE, new PrimitiveArrayListerFloat());
    }

    @Override
    public ListIterator<Float> iterator(final float[] fArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Float>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < fArray.length;
            }

            @Override
            public Float next() {
                return Float.valueOf(fArray[this.idx++]);
            }
        };
    }

    @Override
    public FloatArrayPack startPacking(BeanT BeanT, Accessor<BeanT, float[]> accessor) {
        return new FloatArrayPack();
    }

    @Override
    public void addToPack(FloatArrayPack floatArrayPack, Float f) {
        floatArrayPack.add(f);
    }

    @Override
    public void endPacking(FloatArrayPack floatArrayPack, BeanT BeanT, Accessor<BeanT, float[]> accessor) throws AccessorException {
        accessor.set(BeanT, floatArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, float[]> accessor) throws AccessorException {
        accessor.set(BeanT, new float[0]);
    }

    static final class FloatArrayPack {
        float[] buf = new float[16];
        int size;

        FloatArrayPack() {
        }

        void add(Float f) {
            if (this.buf.length == this.size) {
                float[] fArray = new float[this.buf.length * 2];
                System.arraycopy(this.buf, 0, fArray, 0, this.buf.length);
                this.buf = fArray;
            }
            this.buf[this.size++] = f.floatValue();
        }

        float[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            float[] fArray = new float[this.size];
            System.arraycopy(this.buf, 0, fArray, 0, this.size);
            return fArray;
        }
    }
}

