/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.reflect;

import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.ListIterator;
import org.jvnet.jaxb.reflection.runtime.reflect.Lister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveArrayListerCharacter<BeanT>
extends Lister<BeanT, char[], Character, CharacterArrayPack> {
    private PrimitiveArrayListerCharacter() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Character.TYPE, new PrimitiveArrayListerCharacter());
    }

    @Override
    public ListIterator<Character> iterator(final char[] cArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Character>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < cArray.length;
            }

            @Override
            public Character next() {
                return Character.valueOf(cArray[this.idx++]);
            }
        };
    }

    @Override
    public CharacterArrayPack startPacking(BeanT BeanT, Accessor<BeanT, char[]> accessor) {
        return new CharacterArrayPack();
    }

    @Override
    public void addToPack(CharacterArrayPack characterArrayPack, Character c) {
        characterArrayPack.add(c);
    }

    @Override
    public void endPacking(CharacterArrayPack characterArrayPack, BeanT BeanT, Accessor<BeanT, char[]> accessor) throws AccessorException {
        accessor.set(BeanT, characterArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, char[]> accessor) throws AccessorException {
        accessor.set(BeanT, new char[0]);
    }

    static final class CharacterArrayPack {
        char[] buf = new char[16];
        int size;

        CharacterArrayPack() {
        }

        void add(Character c) {
            if (this.buf.length == this.size) {
                char[] cArray = new char[this.buf.length * 2];
                System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                this.buf = cArray;
            }
            this.buf[this.size++] = c.charValue();
        }

        char[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            char[] cArray = new char[this.size];
            System.arraycopy(this.buf, 0, cArray, 0, this.size);
            return cArray;
        }
    }
}

