/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.reflect;

import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.ListIterator;
import org.jvnet.jaxb.reflection.runtime.reflect.Lister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveArrayListerBoolean<BeanT>
extends Lister<BeanT, boolean[], Boolean, BooleanArrayPack> {
    private PrimitiveArrayListerBoolean() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Boolean.TYPE, new PrimitiveArrayListerBoolean());
    }

    @Override
    public ListIterator<Boolean> iterator(final boolean[] blArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Boolean>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < blArray.length;
            }

            @Override
            public Boolean next() {
                return blArray[this.idx++];
            }
        };
    }

    @Override
    public BooleanArrayPack startPacking(BeanT BeanT, Accessor<BeanT, boolean[]> accessor) {
        return new BooleanArrayPack();
    }

    @Override
    public void addToPack(BooleanArrayPack booleanArrayPack, Boolean bl) {
        booleanArrayPack.add(bl);
    }

    @Override
    public void endPacking(BooleanArrayPack booleanArrayPack, BeanT BeanT, Accessor<BeanT, boolean[]> accessor) throws AccessorException {
        accessor.set(BeanT, booleanArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, boolean[]> accessor) throws AccessorException {
        accessor.set(BeanT, new boolean[0]);
    }

    static final class BooleanArrayPack {
        boolean[] buf = new boolean[16];
        int size;

        BooleanArrayPack() {
        }

        void add(Boolean bl) {
            if (this.buf.length == this.size) {
                boolean[] blArray = new boolean[this.buf.length * 2];
                System.arraycopy(this.buf, 0, blArray, 0, this.buf.length);
                this.buf = blArray;
            }
            this.buf[this.size++] = bl;
        }

        boolean[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            boolean[] blArray = new boolean[this.size];
            System.arraycopy(this.buf, 0, blArray, 0, this.size);
            return blArray;
        }
    }
}

