/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.property;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.jvnet.jaxb.reflection.model.core.ID;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeAttributePropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeElementPropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeNonElement;
import org.jvnet.jaxb.reflection.model.runtime.RuntimePropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeTypeInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeValuePropertyInfo;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.property.ArrayElementLeafProperty;
import org.jvnet.jaxb.reflection.runtime.property.ArrayElementNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.ArrayReferenceNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.AttributeProperty;
import org.jvnet.jaxb.reflection.runtime.property.ListElementProperty;
import org.jvnet.jaxb.reflection.runtime.property.Property;
import org.jvnet.jaxb.reflection.runtime.property.SingleElementLeafProperty;
import org.jvnet.jaxb.reflection.runtime.property.SingleElementNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.SingleMapNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.SingleReferenceNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.ValueProperty;

public abstract class PropertyFactory {
    private static final Constructor<? extends Property>[] propImpls;

    private PropertyFactory() {
    }

    public static Property create(JAXBContextImpl jAXBContextImpl, RuntimePropertyInfo runtimePropertyInfo) {
        PropertyKind propertyKind = runtimePropertyInfo.kind();
        switch (propertyKind) {
            case ATTRIBUTE: {
                return new AttributeProperty(jAXBContextImpl, (RuntimeAttributePropertyInfo)runtimePropertyInfo);
            }
            case VALUE: {
                return new ValueProperty(jAXBContextImpl, (RuntimeValuePropertyInfo)runtimePropertyInfo);
            }
            case ELEMENT: {
                if (!((RuntimeElementPropertyInfo)runtimePropertyInfo).isValueList()) break;
                return new ListElementProperty(jAXBContextImpl, (RuntimeElementPropertyInfo)runtimePropertyInfo);
            }
            case REFERENCE: 
            case MAP: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean bl = runtimePropertyInfo.isCollection();
        boolean bl2 = PropertyFactory.isLeaf(runtimePropertyInfo);
        Constructor<? extends Property> constructor = propImpls[(bl2 ? 0 : 6) + (bl ? 3 : 0) + propertyKind.propertyIndex];
        try {
            return constructor.newInstance(new Object[]{jAXBContextImpl, runtimePropertyInfo});
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
    }

    static boolean isLeaf(RuntimePropertyInfo runtimePropertyInfo) {
        Collection<? extends RuntimeTypeInfo> collection = runtimePropertyInfo.ref();
        if (collection.size() != 1) {
            return false;
        }
        RuntimeTypeInfo runtimeTypeInfo = collection.iterator().next();
        if (!(runtimeTypeInfo instanceof RuntimeNonElement)) {
            return false;
        }
        if (runtimePropertyInfo.id() == ID.IDREF) {
            return true;
        }
        if (((RuntimeNonElement)runtimeTypeInfo).getTransducer() == null) {
            return false;
        }
        return runtimePropertyInfo.getIndividualType().equals(runtimeTypeInfo.getType());
    }

    static {
        Class[] classArray = new Class[]{SingleElementLeafProperty.class, null, null, ArrayElementLeafProperty.class, null, null, SingleElementNodeProperty.class, SingleReferenceNodeProperty.class, SingleMapNodeProperty.class, ArrayElementNodeProperty.class, ArrayReferenceNodeProperty.class, null};
        propImpls = new Constructor[classArray.length];
        for (int i = 0; i < propImpls.length; ++i) {
            if (classArray[i] == null) continue;
            PropertyFactory.propImpls[i] = classArray[i].getConstructors()[0];
        }
    }
}

