/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.helpers.PrintConversionEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.jvnet.jaxb.reflection.impl.util.ValidationEventLocatorExImpl;
import org.jvnet.jaxb.reflection.runtime.Messages;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.xml.sax.SAXException;

public class RuntimeUtil {
    public static final Map<Class, Class> boxToPrimitive;
    public static final Map<Class, Class> primitiveToBox;

    public static void handlePrintConversionException(Object object, Exception exception, XMLSerializer xMLSerializer) throws SAXException {
        if (exception instanceof SAXException) {
            throw (SAXException)exception;
        }
        PrintConversionEventImpl printConversionEventImpl = new PrintConversionEventImpl(1, exception.getMessage(), (ValidationEventLocator)new ValidationEventLocatorImpl(object), (Throwable)exception);
        xMLSerializer.reportError((ValidationEvent)printConversionEventImpl);
    }

    public static void handleTypeMismatchError(XMLSerializer xMLSerializer, Object object, String string, Object object2) throws SAXException {
        ValidationEventImpl validationEventImpl = new ValidationEventImpl(1, Messages.TYPE_MISMATCH.format(RuntimeUtil.getTypeName(object), string, RuntimeUtil.getTypeName(object2)), (ValidationEventLocator)new ValidationEventLocatorExImpl(object, string));
        xMLSerializer.reportError((ValidationEvent)validationEventImpl);
    }

    private static String getTypeName(Object object) {
        return object.getClass().getName();
    }

    static {
        HashMap<Class<Object>, Class<Void>> hashMap = new HashMap<Class<Object>, Class<Void>>();
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Boolean.TYPE, Boolean.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Double.TYPE, Double.class);
        hashMap.put(Void.TYPE, Void.class);
        primitiveToBox = Collections.unmodifiableMap(hashMap);
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getValue(), entry.getKey());
        }
        boxToPrimitive = Collections.unmodifiableMap(hashMap2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ToStringAdapter
    extends XmlAdapter<String, Object> {
        public Object unmarshal(String string) {
            throw new UnsupportedOperationException();
        }

        public String marshal(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }
    }
}

