/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.reflection.runtime.Name;
import org.jvnet.jaxb.reflection.runtime.NameList;
import org.jvnet.jaxb.reflection.util.QNameMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameBuilder {
    private Map<String, Integer> uriIndexMap = new HashMap<String, Integer>();
    private Set<String> nonDefaultableNsUris = new HashSet<String>();
    private Map<String, Integer> localNameIndexMap = new HashMap<String, Integer>();
    private QNameMap<Integer> elementQNameIndexMap = new QNameMap();
    private QNameMap<Integer> attributeQNameIndexMap = new QNameMap();

    public Name createElementName(QName qName) {
        return this.createElementName(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public Name createElementName(String string, String string2) {
        return this.createName(string, string2, false, this.elementQNameIndexMap);
    }

    public Name createAttributeName(QName qName) {
        return this.createAttributeName(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public Name createAttributeName(String string, String string2) {
        assert (string.intern() == string);
        assert (string2.intern() == string2);
        if (string.length() == 0) {
            return new Name(this.allocIndex(this.attributeQNameIndexMap, "", string2), -1, string, this.allocIndex(this.localNameIndexMap, string2), string2, true);
        }
        this.nonDefaultableNsUris.add(string);
        return this.createName(string, string2, true, this.attributeQNameIndexMap);
    }

    private Name createName(String string, String string2, boolean bl, QNameMap<Integer> qNameMap) {
        assert (string.intern() == string);
        assert (string2.intern() == string2);
        return new Name(this.allocIndex(qNameMap, string, string2), this.allocIndex(this.uriIndexMap, string), string, this.allocIndex(this.localNameIndexMap, string2), string2, bl);
    }

    private int allocIndex(Map<String, Integer> map, String string) {
        Integer n = map.get(string);
        if (n == null) {
            n = map.size();
            map.put(string, n);
        }
        return n;
    }

    private int allocIndex(QNameMap<Integer> qNameMap, String string, String string2) {
        Integer n = qNameMap.get(string, string2);
        if (n == null) {
            n = qNameMap.size();
            qNameMap.put(string, string2, n);
        }
        return n;
    }

    public NameList conclude() {
        boolean[] blArray = new boolean[this.uriIndexMap.size()];
        for (Map.Entry<String, Integer> entry : this.uriIndexMap.entrySet()) {
            blArray[entry.getValue().intValue()] = this.nonDefaultableNsUris.contains(entry.getKey());
        }
        NameList nameList = new NameList(this.list(this.uriIndexMap), blArray, this.list(this.localNameIndexMap), this.elementQNameIndexMap.size(), this.attributeQNameIndexMap.size());
        this.uriIndexMap = null;
        this.localNameIndexMap = null;
        return nameList;
    }

    private String[] list(Map<String, Integer> map) {
        String[] stringArray = new String[map.size()];
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            stringArray[entry.getValue().intValue()] = entry.getKey();
        }
        return stringArray;
    }
}

