/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.binding.ConstraintType;
import org.hibernate.validator.internal.xml.binding.FieldType;

class ConstrainedFieldBuilder {
    private static final Log log = LoggerFactory.make();
    private final GroupConversionBuilder groupConversionBuilder;
    private final MetaConstraintBuilder metaConstraintBuilder;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;

    ConstrainedFieldBuilder(MetaConstraintBuilder metaConstraintBuilder, GroupConversionBuilder groupConversionBuilder, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        this.metaConstraintBuilder = metaConstraintBuilder;
        this.groupConversionBuilder = groupConversionBuilder;
        this.annotationProcessingOptions = annotationProcessingOptions;
    }

    Set<ConstrainedField> buildConstrainedFields(List<FieldType> fields, Class<?> beanClass, String defaultPackage) {
        HashSet<ConstrainedField> constrainedFields = CollectionHelper.newHashSet();
        ArrayList<String> alreadyProcessedFieldNames = CollectionHelper.newArrayList();
        for (FieldType fieldType : fields) {
            Field field = ConstrainedFieldBuilder.findField(beanClass, fieldType.getName(), alreadyProcessedFieldNames);
            ConstraintLocation constraintLocation = ConstraintLocation.forField(field);
            HashSet<MetaConstraint<?>> metaConstraints = CollectionHelper.newHashSet();
            for (ConstraintType constraint : fieldType.getConstraint()) {
                MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.FIELD, defaultPackage, null);
                metaConstraints.add(metaConstraint);
            }
            Map<Class<?>, Class<?>> groupConversions = this.groupConversionBuilder.buildGroupConversionMap(fieldType.getConvertGroup(), defaultPackage);
            ConstrainedField constrainedField = new ConstrainedField(ConfigurationSource.XML, field, metaConstraints, Collections.emptySet(), groupConversions, this.getCascadedTypeParameters(field, fieldType.getValid() != null));
            constrainedFields.add(constrainedField);
            if (fieldType.getIgnoreAnnotations() == null) continue;
            this.annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(field, fieldType.getIgnoreAnnotations());
        }
        return constrainedFields;
    }

    private List<CascadingTypeParameter> getCascadedTypeParameters(Field field, boolean isCascaded) {
        if (isCascaded) {
            return Collections.singletonList(field.getType().isArray() ? CascadingTypeParameter.arrayElement(ReflectionHelper.typeOf(field)) : CascadingTypeParameter.annotatedObject(ReflectionHelper.typeOf(field)));
        }
        return Collections.emptyList();
    }

    private static Field findField(Class<?> beanClass, String fieldName, List<String> alreadyProcessedFieldNames) {
        if (alreadyProcessedFieldNames.contains(fieldName)) {
            throw log.getIsDefinedTwiceInMappingXmlForBeanException(fieldName, beanClass);
        }
        alreadyProcessedFieldNames.add(fieldName);
        Field field = ConstrainedFieldBuilder.run(GetDeclaredField.action(beanClass, fieldName));
        if (field == null) {
            throw log.getBeanDoesNotContainTheFieldException(beanClass, fieldName);
        }
        return field;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

