/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ConstrainedParameter
extends AbstractConstrainedElement {
    private final Executable executable;
    private final Type type;
    private final String name;
    private final int index;

    public ConstrainedParameter(ConfigurationSource source, Executable executable, Type type, int index, String name) {
        this(source, executable, type, index, name, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), Collections.emptyList());
    }

    public ConstrainedParameter(ConfigurationSource source, Executable executable, Type type, int index, String name, Set<MetaConstraint<?>> constraints, Set<MetaConstraint<?>> typeArgumentConstraints, Map<Class<?>, Class<?>> groupConversions, List<CascadingTypeParameter> cascadingTypeParameters) {
        super(source, ConstrainedElement.ConstrainedElementKind.PARAMETER, constraints, typeArgumentConstraints, groupConversions, cascadingTypeParameters);
        this.executable = executable;
        this.type = type;
        this.name = name;
        this.index = index;
    }

    public Type getType() {
        return this.type;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public ConstrainedParameter merge(ConstrainedParameter other) {
        ConfigurationSource mergedSource = ConfigurationSource.max(this.source, other.source);
        String mergedName = this.source.getPriority() > other.source.getPriority() ? this.name : other.name;
        HashSet<MetaConstraint<?>> mergedConstraints = CollectionHelper.newHashSet(this.constraints);
        mergedConstraints.addAll(other.constraints);
        HashSet mergedTypeArgumentConstraints = new HashSet(this.typeArgumentConstraints);
        mergedTypeArgumentConstraints.addAll(other.typeArgumentConstraints);
        HashMap<Class<?>, Class<?>> mergedGroupConversions = CollectionHelper.newHashMap(this.groupConversions);
        mergedGroupConversions.putAll(other.groupConversions);
        ArrayList<CascadingTypeParameter> mergedCascadingTypeParameters = new ArrayList<CascadingTypeParameter>(this.cascadingTypeParameters);
        mergedCascadingTypeParameters.addAll(other.cascadingTypeParameters);
        return new ConstrainedParameter(mergedSource, this.executable, this.type, this.index, mergedName, mergedConstraints, mergedTypeArgumentConstraints, mergedGroupConversions, mergedCascadingTypeParameters);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MetaConstraint<?> oneConstraint : this.getConstraints()) {
            sb.append(oneConstraint.getDescriptor().getAnnotation().annotationType().getSimpleName());
            sb.append(", ");
        }
        String constraintsAsString = sb.length() > 0 ? sb.substring(0, sb.length() - 2) : sb.toString();
        return "ParameterMetaData [executable=" + this.executable + "], name=" + this.name + "], constraints=[" + constraintsAsString + "], isCascading=" + this.isCascading() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstrainedParameter other = (ConstrainedParameter)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.executable == null ? other.executable != null : !this.executable.equals(other.executable));
    }
}

