/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;

public abstract class AbstractConstrainedElement
implements ConstrainedElement {
    private final ConstrainedElement.ConstrainedElementKind kind;
    protected final ConfigurationSource source;
    protected final Set<MetaConstraint<?>> constraints;
    protected final Map<Class<?>, Class<?>> groupConversions;
    protected final List<CascadingTypeParameter> cascadingTypeParameters;
    protected final Set<MetaConstraint<?>> typeArgumentConstraints;

    public AbstractConstrainedElement(ConfigurationSource source, ConstrainedElement.ConstrainedElementKind kind, Set<MetaConstraint<?>> constraints, Set<MetaConstraint<?>> typeArgumentConstraints, Map<Class<?>, Class<?>> groupConversions, List<CascadingTypeParameter> cascadingTypeParameters) {
        this.kind = kind;
        this.source = source;
        this.constraints = constraints != null ? Collections.unmodifiableSet(constraints) : Collections.emptySet();
        this.typeArgumentConstraints = typeArgumentConstraints != null ? Collections.unmodifiableSet(typeArgumentConstraints) : Collections.emptySet();
        this.groupConversions = Collections.unmodifiableMap(groupConversions);
        this.cascadingTypeParameters = cascadingTypeParameters;
    }

    @Override
    public ConstrainedElement.ConstrainedElementKind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<MetaConstraint<?>> iterator() {
        return this.constraints.iterator();
    }

    @Override
    public Set<MetaConstraint<?>> getConstraints() {
        return this.constraints;
    }

    @Override
    public Set<MetaConstraint<?>> getTypeArgumentConstraints() {
        return this.typeArgumentConstraints;
    }

    @Override
    public Map<Class<?>, Class<?>> getGroupConversions() {
        return this.groupConversions;
    }

    @Override
    public boolean isCascading() {
        return !this.cascadingTypeParameters.isEmpty();
    }

    @Override
    public List<CascadingTypeParameter> getCascadingTypeParameters() {
        return this.cascadingTypeParameters;
    }

    @Override
    public boolean isConstrained() {
        return this.isCascading() || !this.constraints.isEmpty() || !this.typeArgumentConstraints.isEmpty();
    }

    @Override
    public ConfigurationSource getSource() {
        return this.source;
    }

    public String toString() {
        return "AbstractConstrainedElement [kind=" + (Object)((Object)this.kind) + ", source=" + (Object)((Object)this.source) + ", constraints=" + this.constraints + ", groupConversions=" + this.groupConversions + ", cascadingTypeParameters=" + this.cascadingTypeParameters + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConstrainedElement other = (AbstractConstrainedElement)obj;
        return this.source == other.source;
    }
}

