/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.GroupSequence;
import javax.validation.Valid;
import javax.validation.groups.ConvertGroup;
import org.hibernate.validator.group.GroupSequenceProvider;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.core.MetaConstraints;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructors;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredFields;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.internal.util.privilegedactions.GetMethods;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public class AnnotationMetaDataProvider
implements MetaDataProvider {
    private static final Log log = LoggerFactory.make();
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected final ConstraintHelper constraintHelper;
    protected final TypeResolutionHelper typeResolutionHelper;
    protected final ConcurrentReferenceHashMap<Class<?>, BeanConfiguration<?>> configuredBeans;
    protected final AnnotationProcessingOptions annotationProcessingOptions;
    protected final ExecutableParameterNameProvider parameterNameProvider;
    protected final ValueExtractorManager valueExtractorManager;

    public AnnotationMetaDataProvider(ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ExecutableParameterNameProvider parameterNameProvider, ValueExtractorManager valueExtractorManager, AnnotationProcessingOptions annotationProcessingOptions) {
        this.constraintHelper = constraintHelper;
        this.typeResolutionHelper = typeResolutionHelper;
        this.parameterNameProvider = parameterNameProvider;
        this.valueExtractorManager = valueExtractorManager;
        this.annotationProcessingOptions = annotationProcessingOptions;
        this.configuredBeans = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    }

    @Override
    public AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return new AnnotationProcessingOptionsImpl();
    }

    public <T> BeanConfiguration<T> getBeanConfiguration(Class<T> beanClass) {
        BeanConfiguration<Object> configuration = this.configuredBeans.get(beanClass);
        if (configuration != null) {
            return configuration;
        }
        configuration = this.retrieveBeanConfiguration(beanClass);
        this.configuredBeans.put(beanClass, configuration);
        return configuration;
    }

    private <T> BeanConfiguration<T> retrieveBeanConfiguration(Class<T> beanClass) {
        Set<ConstrainedElement> constrainedElements = this.getFieldMetaData(beanClass);
        constrainedElements.addAll(this.getMethodMetaData(beanClass));
        constrainedElements.addAll(this.getConstructorMetaData(beanClass));
        Set<MetaConstraint<?>> classLevelConstraints = this.getClassLevelConstraints(beanClass);
        if (!classLevelConstraints.isEmpty()) {
            ConstrainedType classLevelMetaData = new ConstrainedType(ConfigurationSource.ANNOTATION, beanClass, classLevelConstraints);
            constrainedElements.add(classLevelMetaData);
        }
        return new BeanConfiguration<T>(ConfigurationSource.ANNOTATION, beanClass, constrainedElements, this.getDefaultGroupSequence(beanClass), this.getDefaultGroupSequenceProvider(beanClass));
    }

    private List<Class<?>> getDefaultGroupSequence(Class<?> beanClass) {
        GroupSequence groupSequenceAnnotation = beanClass.getAnnotation(GroupSequence.class);
        return groupSequenceAnnotation != null ? Arrays.asList(groupSequenceAnnotation.value()) : null;
    }

    private <T> DefaultGroupSequenceProvider<? super T> getDefaultGroupSequenceProvider(Class<T> beanClass) {
        GroupSequenceProvider groupSequenceProviderAnnotation = beanClass.getAnnotation(GroupSequenceProvider.class);
        if (groupSequenceProviderAnnotation != null) {
            Class<? extends DefaultGroupSequenceProvider<?>> providerClass = groupSequenceProviderAnnotation.value();
            return this.newGroupSequenceProviderClassInstance(beanClass, providerClass);
        }
        return null;
    }

    private <T> DefaultGroupSequenceProvider<? super T> newGroupSequenceProviderClassInstance(Class<T> beanClass, Class<? extends DefaultGroupSequenceProvider<? super T>> providerClass) {
        Method[] providerMethods;
        for (Method method : providerMethods = this.run(GetMethods.action(providerClass))) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!"getValidationGroups".equals(method.getName()) || method.isBridge() || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(beanClass)) continue;
            return this.run(NewInstance.action(providerClass, "the default group sequence provider"));
        }
        throw log.getWrongDefaultGroupSequenceProviderTypeException(beanClass);
    }

    private Set<MetaConstraint<?>> getClassLevelConstraints(Class<?> clazz) {
        if (this.annotationProcessingOptions.areClassLevelConstraintsIgnoredFor(clazz)) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> classLevelConstraints = CollectionHelper.newHashSet();
        List<ConstraintDescriptorImpl<?>> classMetaData = this.findClassLevelConstraints(clazz);
        ConstraintLocation location = ConstraintLocation.forClass(clazz);
        for (ConstraintDescriptorImpl<?> constraintDescription : classMetaData) {
            classLevelConstraints.add(MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, constraintDescription, location));
        }
        return classLevelConstraints;
    }

    private Set<ConstrainedElement> getFieldMetaData(Class<?> beanClass) {
        HashSet<ConstrainedElement> propertyMetaData = CollectionHelper.newHashSet();
        for (Field field : this.run(GetDeclaredFields.action(beanClass))) {
            if (Modifier.isStatic(field.getModifiers()) || this.annotationProcessingOptions.areMemberConstraintsIgnoredFor(field) || field.isSynthetic()) continue;
            propertyMetaData.add(this.findPropertyMetaData(field));
        }
        return propertyMetaData;
    }

    private ConstrainedField findPropertyMetaData(Field field) {
        Set<MetaConstraint<?>> constraints = this.convertToMetaConstraints(this.findConstraints(field, ElementType.FIELD), field);
        Map<Class<?>, Class<?>> groupConversions = this.getGroupConversions(field.getAnnotation(ConvertGroup.class), field.getAnnotation(ConvertGroup.List.class));
        List<CascadingTypeParameter> cascadingTypeParameters = this.findCascadingTypeParameters(field);
        Set<MetaConstraint<?>> typeArgumentsConstraints = this.findTypeAnnotationConstraints(field);
        return new ConstrainedField(ConfigurationSource.ANNOTATION, field, constraints, typeArgumentsConstraints, groupConversions, cascadingTypeParameters);
    }

    private Set<MetaConstraint<?>> convertToMetaConstraints(List<ConstraintDescriptorImpl<?>> constraintDescriptors, Field field) {
        if (constraintDescriptors.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        ConstraintLocation location = ConstraintLocation.forField(field);
        for (ConstraintDescriptorImpl<?> constraintDescription : constraintDescriptors) {
            constraints.add(MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, constraintDescription, location));
        }
        return constraints;
    }

    private Set<ConstrainedExecutable> getConstructorMetaData(Class<?> clazz) {
        Executable[] declaredConstructors = this.run(GetDeclaredConstructors.action(clazz));
        return this.getMetaData(declaredConstructors);
    }

    private Set<ConstrainedExecutable> getMethodMetaData(Class<?> clazz) {
        Executable[] declaredMethods = this.run(GetDeclaredMethods.action(clazz));
        return this.getMetaData(declaredMethods);
    }

    private Set<ConstrainedExecutable> getMetaData(Executable[] executableElements) {
        HashSet<ConstrainedExecutable> executableMetaData = CollectionHelper.newHashSet();
        for (Executable executable : executableElements) {
            if (Modifier.isStatic(executable.getModifiers()) || executable.isSynthetic()) continue;
            executableMetaData.add(this.findExecutableMetaData(executable));
        }
        return executableMetaData;
    }

    private ConstrainedExecutable findExecutableMetaData(Executable executable) {
        List<CascadingTypeParameter> cascadingTypeParameters;
        Map<Class<?>, Class<?>> groupConversions;
        Set<MetaConstraint<?>> typeArgumentsConstraints;
        Set<MetaConstraint<?>> returnValueConstraints;
        List<ConstrainedParameter> parameterConstraints = this.getParameterMetaData(executable);
        Map<ConstraintDescriptorImpl.ConstraintType, List<ConstraintDescriptorImpl>> executableConstraints = this.findConstraints(executable, ExecutableHelper.getElementType(executable)).stream().collect(Collectors.groupingBy(ConstraintDescriptorImpl::getConstraintType));
        Set<Object> crossParameterConstraints = this.annotationProcessingOptions.areCrossParameterConstraintsIgnoredFor(executable) ? Collections.emptySet() : this.convertToMetaConstraints(executableConstraints.get((Object)ConstraintDescriptorImpl.ConstraintType.CROSS_PARAMETER), executable);
        if (this.annotationProcessingOptions.areReturnValueConstraintsIgnoredFor(executable)) {
            returnValueConstraints = Collections.emptySet();
            typeArgumentsConstraints = Collections.emptySet();
            groupConversions = Collections.emptyMap();
            cascadingTypeParameters = Collections.emptyList();
        } else {
            typeArgumentsConstraints = this.findTypeAnnotationConstraints(executable);
            returnValueConstraints = this.convertToMetaConstraints(executableConstraints.get((Object)ConstraintDescriptorImpl.ConstraintType.GENERIC), executable);
            groupConversions = this.getGroupConversions(executable.getAnnotation(ConvertGroup.class), executable.getAnnotation(ConvertGroup.List.class));
            cascadingTypeParameters = this.findCascadingTypeParameters(executable);
        }
        return new ConstrainedExecutable(ConfigurationSource.ANNOTATION, executable, parameterConstraints, crossParameterConstraints, returnValueConstraints, typeArgumentsConstraints, groupConversions, cascadingTypeParameters);
    }

    private Set<MetaConstraint<?>> convertToMetaConstraints(List<ConstraintDescriptorImpl<?>> constraintsDescriptors, Executable executable) {
        if (constraintsDescriptors == null) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        ConstraintLocation returnValueLocation = ConstraintLocation.forReturnValue(executable);
        ConstraintLocation crossParameterLocation = ConstraintLocation.forCrossParameter(executable);
        for (ConstraintDescriptorImpl<?> constraintDescriptor : constraintsDescriptors) {
            ConstraintLocation location = constraintDescriptor.getConstraintType() == ConstraintDescriptorImpl.ConstraintType.GENERIC ? returnValueLocation : crossParameterLocation;
            constraints.add(MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, constraintDescriptor, location));
        }
        return constraints;
    }

    private List<ConstrainedParameter> getParameterMetaData(Executable executable) {
        ArrayList<ConstrainedParameter> metaData = CollectionHelper.newArrayList();
        List<String> parameterNames = this.parameterNameProvider.getParameterNames(executable);
        int i = 0;
        for (Parameter parameter : executable.getParameters()) {
            Annotation[] parameterAnnotations;
            try {
                parameterAnnotations = parameter.getAnnotations();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                log.warn(Messages.MESSAGES.constraintOnConstructorOfNonStaticInnerClass(), ex);
                parameterAnnotations = new Annotation[]{};
            }
            String parameterName = parameterNames.get(i);
            HashSet<MetaConstraint<?>> parameterConstraints = CollectionHelper.newHashSet();
            ConvertGroup groupConversion = null;
            ConvertGroup.List groupConversionList = null;
            if (this.annotationProcessingOptions.areParameterConstraintsIgnoredFor(executable, i)) {
                metaData.add(new ConstrainedParameter(ConfigurationSource.ANNOTATION, executable, ReflectionHelper.typeOf(executable, i), i, parameterName, parameterConstraints, Collections.emptySet(), this.getGroupConversions(groupConversion, groupConversionList), Collections.emptyList()));
                ++i;
                continue;
            }
            ConstraintLocation location = ConstraintLocation.forParameter(executable, i);
            for (Annotation parameterAnnotation : parameterAnnotations) {
                if (parameterAnnotation.annotationType().equals(ConvertGroup.class)) {
                    groupConversion = (ConvertGroup)parameterAnnotation;
                } else if (parameterAnnotation.annotationType().equals(ConvertGroup.List.class)) {
                    groupConversionList = (ConvertGroup.List)parameterAnnotation;
                }
                List<ConstraintDescriptorImpl<?>> constraints = this.findConstraintAnnotations(executable, parameterAnnotation, ElementType.PARAMETER);
                for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : constraints) {
                    parameterConstraints.add(MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, constraintDescriptorImpl, location));
                }
            }
            Set<MetaConstraint<?>> typeArgumentsConstraints = this.findTypeAnnotationConstraintsForExecutableParameter(executable, i);
            List<CascadingTypeParameter> cascadingTypeParameters = this.findCascadingTypeParameters(executable, i);
            metaData.add(new ConstrainedParameter(ConfigurationSource.ANNOTATION, executable, ReflectionHelper.typeOf(executable, i), i, parameterName, parameterConstraints, typeArgumentsConstraints, this.getGroupConversions(groupConversion, groupConversionList), cascadingTypeParameters));
            ++i;
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findConstraints(Member member, ElementType type) {
        ArrayList<ConstraintDescriptorImpl<?>> metaData = CollectionHelper.newArrayList();
        for (Annotation annotation : ((AccessibleObject)((Object)member)).getDeclaredAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(member, annotation, type));
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList<ConstraintDescriptorImpl<?>> metaData = CollectionHelper.newArrayList();
        for (Annotation annotation : beanClass.getDeclaredAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(null, annotation, ElementType.TYPE));
        }
        return metaData;
    }

    protected <A extends Annotation> List<ConstraintDescriptorImpl<?>> findConstraintAnnotations(Member member, A annotation, ElementType type) {
        if (this.isJdkInternalType(annotation)) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintDescriptorImpl<?>> constraintDescriptors = CollectionHelper.newArrayList();
        ArrayList<Annotation> constraints = CollectionHelper.newArrayList();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (this.constraintHelper.isConstraintAnnotation(annotationType)) {
            constraints.add(annotation);
        } else if (this.constraintHelper.isMultiValueConstraint(annotationType)) {
            constraints.addAll(this.constraintHelper.getConstraintsFromMultiValueConstraint(annotation));
        }
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl<Annotation> constraintDescriptor = this.buildConstraintDescriptor(member, constraint, type);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> boolean isJdkInternalType(A annotation) {
        Package pakkage = annotation.annotationType().getPackage();
        return pakkage != null && "jdk.internal".equals(pakkage.getName());
    }

    private Map<Class<?>, Class<?>> getGroupConversions(ConvertGroup groupConversion, ConvertGroup.List groupConversionList) {
        HashMap<Class<?>, Class<?>> groupConversions = CollectionHelper.newHashMap();
        if (groupConversion != null) {
            groupConversions.put(groupConversion.from(), groupConversion.to());
        }
        if (groupConversionList != null) {
            for (ConvertGroup conversion : groupConversionList.value()) {
                if (groupConversions.containsKey(conversion.from())) {
                    throw log.getMultipleGroupConversionsForSameSourceException(conversion.from(), CollectionHelper.asSet((Class)groupConversions.get(conversion.from()), conversion.to()));
                }
                groupConversions.put(conversion.from(), conversion.to());
            }
        }
        return groupConversions;
    }

    private <A extends Annotation> ConstraintDescriptorImpl<A> buildConstraintDescriptor(Member member, A annotation, ElementType type) {
        return new ConstraintDescriptorImpl<A>(this.constraintHelper, member, annotation, type);
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    protected Set<MetaConstraint<?>> findTypeAnnotationConstraints(Field field) {
        return this.findTypeArgumentsConstraints(field, new TypeArgumentFieldLocation(field), field.getAnnotatedType(), field.getType().getTypeParameters());
    }

    protected Set<MetaConstraint<?>> findTypeAnnotationConstraints(Executable executable) {
        TypeVariable[] typeParameters = executable instanceof Method ? ((Method)executable).getReturnType().getTypeParameters() : new TypeVariable[]{};
        return this.findTypeArgumentsConstraints(executable, new TypeArgumentReturnValueLocation(executable), executable.getAnnotatedReturnType(), typeParameters);
    }

    private List<CascadingTypeParameter> findCascadingTypeParameters(Executable executable, int i) {
        Parameter parameter = executable.getParameters()[i];
        TypeVariable<Class<?>>[] typeParameters = parameter.getType().getTypeParameters();
        AnnotatedType annotatedType = parameter.getAnnotatedType();
        List<CascadingTypeParameter> cascadingTypeParameters = this.getCascadingTypeParameters(typeParameters, annotatedType);
        try {
            if (parameter.isAnnotationPresent(Valid.class)) {
                cascadingTypeParameters.add(parameter.getType().isArray() ? CascadingTypeParameter.arrayElement(ReflectionHelper.typeOf(parameter.getDeclaringExecutable(), i)) : CascadingTypeParameter.annotatedObject(ReflectionHelper.typeOf(parameter.getDeclaringExecutable(), i)));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.warn(Messages.MESSAGES.constraintOnConstructorOfNonStaticInnerClass(), ex);
        }
        return cascadingTypeParameters.isEmpty() ? Collections.emptyList() : cascadingTypeParameters;
    }

    private List<CascadingTypeParameter> findCascadingTypeParameters(Field field) {
        TypeVariable<Class<?>>[] typeParameters = field.getType().getTypeParameters();
        AnnotatedType annotatedType = field.getAnnotatedType();
        List<CascadingTypeParameter> cascadingTypeParameters = this.getCascadingTypeParameters(typeParameters, annotatedType);
        if (field.isAnnotationPresent(Valid.class)) {
            cascadingTypeParameters.add(field.getType().isArray() ? CascadingTypeParameter.arrayElement(ReflectionHelper.typeOf(field)) : CascadingTypeParameter.annotatedObject(ReflectionHelper.typeOf(field)));
        }
        return cascadingTypeParameters.isEmpty() ? Collections.emptyList() : cascadingTypeParameters;
    }

    private List<CascadingTypeParameter> findCascadingTypeParameters(Executable executable) {
        TypeVariable<Class<Object>>[] typeParameters;
        boolean isArray;
        if (executable instanceof Method) {
            isArray = ((Method)executable).getReturnType().isArray();
            typeParameters = ((Method)executable).getReturnType().getTypeParameters();
        } else {
            isArray = false;
            typeParameters = ((Constructor)executable).getDeclaringClass().getTypeParameters();
        }
        AnnotatedType annotatedType = executable.getAnnotatedReturnType();
        List<CascadingTypeParameter> cascadingTypeParameters = this.getCascadingTypeParameters(typeParameters, annotatedType);
        if (executable.isAnnotationPresent(Valid.class)) {
            cascadingTypeParameters.add(isArray ? CascadingTypeParameter.arrayElement(ReflectionHelper.typeOf(executable)) : CascadingTypeParameter.annotatedObject(ReflectionHelper.typeOf(executable)));
        }
        return cascadingTypeParameters.isEmpty() ? Collections.emptyList() : cascadingTypeParameters;
    }

    private List<CascadingTypeParameter> getCascadingTypeParameters(TypeVariable<?>[] typeParameters, AnnotatedType annotatedType) {
        ArrayList<CascadingTypeParameter> cascadingTypeParameters = new ArrayList<CascadingTypeParameter>();
        if (annotatedType instanceof AnnotatedArrayType) {
            this.addCascadingTypeParametersForArrayType(cascadingTypeParameters, (AnnotatedArrayType)annotatedType);
        } else if (annotatedType instanceof AnnotatedParameterizedType) {
            this.addCascadingTypeParametersForParameterizedType(cascadingTypeParameters, (AnnotatedParameterizedType)annotatedType, typeParameters);
        }
        return cascadingTypeParameters;
    }

    private void addCascadingTypeParametersForParameterizedType(List<CascadingTypeParameter> cascadingTypeParameters, AnnotatedParameterizedType annotatedParameterizedType, TypeVariable<?>[] typeParameters) {
        AnnotatedType[] annotatedTypeArguments = annotatedParameterizedType.getAnnotatedActualTypeArguments();
        int i = 0;
        for (AnnotatedType annotatedTypeArgument : annotatedTypeArguments) {
            Type validatedType = annotatedTypeArgument.getType();
            List<Object> nestedCascadingTypeParameters = validatedType instanceof ParameterizedType ? this.getCascadingTypeParameters(ReflectionHelper.getClassFromType(validatedType).getTypeParameters(), annotatedTypeArgument) : Collections.emptyList();
            boolean isCascading = annotatedTypeArgument.isAnnotationPresent(Valid.class);
            if (isCascading || !nestedCascadingTypeParameters.isEmpty()) {
                CascadingTypeParameter cascadingTypeParameter = new CascadingTypeParameter(annotatedParameterizedType.getType(), typeParameters[i], isCascading, nestedCascadingTypeParameters);
                cascadingTypeParameters.add(cascadingTypeParameter);
            }
            ++i;
        }
    }

    private void addCascadingTypeParametersForArrayType(List<CascadingTypeParameter> cascadingTypeParameters, AnnotatedArrayType annotatedArrayType) {
        Type validatedType = annotatedArrayType.getAnnotatedGenericComponentType().getType();
        List<CascadingTypeParameter> nestedCascadingTypeParameters = validatedType instanceof ParameterizedType ? this.getCascadingTypeParameters(ReflectionHelper.getClassFromType(validatedType).getTypeParameters(), annotatedArrayType.getAnnotatedGenericComponentType()) : Collections.emptyList();
        boolean isCascading = annotatedArrayType.isAnnotationPresent(Valid.class);
        CascadingTypeParameter cascadingTypeParameter = new CascadingTypeParameter(validatedType, ArrayElement.INSTANCE, isCascading, nestedCascadingTypeParameters);
        if (isCascading || !nestedCascadingTypeParameters.isEmpty()) {
            cascadingTypeParameters.add(cascadingTypeParameter);
        }
    }

    protected Set<MetaConstraint<?>> findTypeAnnotationConstraintsForExecutableParameter(Executable executable, int i) {
        Parameter parameter = executable.getParameters()[i];
        try {
            return this.findTypeArgumentsConstraints(executable, new TypeArgumentExecutableParameterLocation(executable, i), parameter.getAnnotatedType(), parameter.getType().getTypeParameters());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.warn(Messages.MESSAGES.constraintOnConstructorOfNonStaticInnerClass(), ex);
            return Collections.emptySet();
        }
    }

    private Set<MetaConstraint<?>> findTypeArgumentsConstraints(Member member, TypeArgumentLocation location, AnnotatedType annotatedType, TypeVariable<?>[] typeParameters) {
        HashSet typeArgumentConstraints = new HashSet();
        AnnotatedType currentAnnotatedType = annotatedType;
        TypeVariable<Object>[] currentTypeParameters = typeParameters;
        TypeArgumentLocation currentLocation = location;
        if (currentAnnotatedType instanceof AnnotatedArrayType) {
            AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)currentAnnotatedType;
            Type validatedType = annotatedArrayType.getAnnotatedGenericComponentType().getType();
            typeArgumentConstraints.addAll(this.findTypeUseConstraints(member, annotatedArrayType, ArrayElement.INSTANCE, location, validatedType));
            currentAnnotatedType = annotatedArrayType.getAnnotatedGenericComponentType();
            if (!(currentAnnotatedType instanceof AnnotatedParameterizedType)) {
                return typeArgumentConstraints.isEmpty() ? Collections.emptySet() : typeArgumentConstraints;
            }
            currentTypeParameters = ReflectionHelper.getClassFromType(validatedType).getTypeParameters();
            currentLocation = new NestedTypeArgumentLocation(location, ArrayElement.INSTANCE, validatedType);
        }
        if (currentAnnotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)currentAnnotatedType;
            int i = 0;
            for (TypeVariable<?> typeVariable : currentTypeParameters) {
                AnnotatedType annotatedTypeParameter = annotatedParameterizedType.getAnnotatedActualTypeArguments()[i];
                Type validatedType = annotatedTypeParameter.getType();
                typeArgumentConstraints.addAll(this.findTypeUseConstraints(member, annotatedTypeParameter, typeVariable, currentLocation, validatedType));
                if (validatedType instanceof ParameterizedType) {
                    typeArgumentConstraints.addAll(this.findTypeArgumentsConstraints(member, new NestedTypeArgumentLocation(currentLocation, typeVariable, validatedType), annotatedTypeParameter, ReflectionHelper.getClassFromType(validatedType).getTypeParameters()));
                }
                ++i;
            }
        }
        return typeArgumentConstraints.isEmpty() ? Collections.emptySet() : typeArgumentConstraints;
    }

    private Set<MetaConstraint<?>> findTypeUseConstraints(Member member, AnnotatedType typeArgument, TypeVariable<?> typeVariable, TypeArgumentLocation location, Type type) {
        Set<MetaConstraint<?>> constraints = Arrays.stream(typeArgument.getAnnotations()).flatMap(a -> this.findConstraintAnnotations(member, a, ElementType.TYPE_USE).stream()).map(d -> this.createTypeArgumentMetaConstraint((ConstraintDescriptorImpl)d, location, typeVariable, type)).collect(Collectors.toSet());
        return constraints;
    }

    private <A extends Annotation> MetaConstraint<?> createTypeArgumentMetaConstraint(ConstraintDescriptorImpl<A> descriptor, TypeArgumentLocation location, TypeVariable<?> typeVariable, Type type) {
        ConstraintLocation constraintLocation = ConstraintLocation.forTypeArgument(location.toConstraintLocation(), typeVariable, type);
        return MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, descriptor, constraintLocation);
    }

    private static class NestedTypeArgumentLocation
    implements TypeArgumentLocation {
        private final TypeArgumentLocation parentLocation;
        private final TypeVariable<?> typeParameter;
        private final Type typeOfAnnotatedElement;

        private NestedTypeArgumentLocation(TypeArgumentLocation parentLocation, TypeVariable<?> typeParameter, Type typeOfAnnotatedElement) {
            this.parentLocation = parentLocation;
            this.typeParameter = typeParameter;
            this.typeOfAnnotatedElement = typeOfAnnotatedElement;
        }

        @Override
        public ConstraintLocation toConstraintLocation() {
            return ConstraintLocation.forTypeArgument(this.parentLocation.toConstraintLocation(), this.typeParameter, this.typeOfAnnotatedElement);
        }
    }

    private static class TypeArgumentReturnValueLocation
    implements TypeArgumentLocation {
        private final Executable executable;

        private TypeArgumentReturnValueLocation(Executable executable) {
            this.executable = executable;
        }

        @Override
        public ConstraintLocation toConstraintLocation() {
            return ConstraintLocation.forReturnValue(this.executable);
        }
    }

    private static class TypeArgumentFieldLocation
    implements TypeArgumentLocation {
        private final Field field;

        private TypeArgumentFieldLocation(Field field) {
            this.field = field;
        }

        @Override
        public ConstraintLocation toConstraintLocation() {
            return ConstraintLocation.forField(this.field);
        }
    }

    private static class TypeArgumentExecutableParameterLocation
    implements TypeArgumentLocation {
        private final Executable executable;
        private final int index;

        private TypeArgumentExecutableParameterLocation(Executable executable, int index) {
            this.executable = executable;
            this.index = index;
        }

        @Override
        public ConstraintLocation toConstraintLocation() {
            return ConstraintLocation.forParameter(this.executable, this.index);
        }
    }

    private static interface TypeArgumentLocation {
        public ConstraintLocation toConstraintLocation();
    }
}

