/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.cascading;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.internal.engine.cascading.AnnotatedObject;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.util.StringHelper;

public class CascadingTypeParameter {
    private final Type enclosingType;
    private final TypeVariable<?> typeParameter;
    private final List<CascadingTypeParameter> nestedCascadingTypeParameters;
    private final boolean cascading;

    public CascadingTypeParameter(Type enclosingType, TypeVariable<?> typeParameter, boolean cascading, List<CascadingTypeParameter> nestedCascadingTypeParameters) {
        this.enclosingType = enclosingType;
        this.typeParameter = typeParameter;
        this.cascading = cascading;
        this.nestedCascadingTypeParameters = Collections.unmodifiableList(nestedCascadingTypeParameters);
    }

    public static CascadingTypeParameter annotatedObject(Type cascadableType) {
        return new CascadingTypeParameter(cascadableType, AnnotatedObject.INSTANCE, true, Collections.emptyList());
    }

    public static CascadingTypeParameter arrayElement(Type cascadableType) {
        return new CascadingTypeParameter(cascadableType, ArrayElement.INSTANCE, true, Collections.emptyList());
    }

    public TypeVariable<?> getTypeParameter() {
        return this.typeParameter;
    }

    public Type getEnclosingType() {
        return this.enclosingType;
    }

    public boolean isCascading() {
        return this.cascading;
    }

    public List<CascadingTypeParameter> getNestedCascadingTypeParameters() {
        return this.nestedCascadingTypeParameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("enclosingType=").append(StringHelper.toShortString(this.enclosingType)).append(", ");
        sb.append("typeParameter=").append(this.typeParameter).append(", ");
        sb.append("cascading=").append(this.cascading).append(", ");
        sb.append("nestedCascadingTypeParameters=").append(this.nestedCascadingTypeParameters);
        sb.append("]");
        return sb.toString();
    }
}

