/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ElementKind;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.FieldCascadable;
import org.hibernate.validator.internal.metadata.aggregated.GetterCascadable;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.core.MetaConstraints;
import org.hibernate.validator.internal.metadata.descriptor.PropertyDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.TypeArgumentConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;

public class PropertyMetaData
extends AbstractConstraintMetaData {
    private final Set<Cascadable> cascadables;

    private PropertyMetaData(String propertyName, Type type, Set<MetaConstraint<?>> constraints, Set<Cascadable> cascadables) {
        super(propertyName, type, constraints, ElementKind.PROPERTY, !cascadables.isEmpty(), !cascadables.isEmpty() || !constraints.isEmpty());
        this.cascadables = cascadables;
    }

    @Override
    public PropertyDescriptorImpl asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new PropertyDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence, this.cascadables.isEmpty() ? Collections.emptySet() : this.cascadables.iterator().next().getGroupConversionDescriptors());
    }

    public Set<Cascadable> getCascadables() {
        return this.cascadables;
    }

    @Override
    public String toString() {
        return "PropertyMetaData [type=" + this.getType() + ", propertyName=" + this.getName() + "]]";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public static class Builder
    extends MetaDataBuilder {
        private static final EnumSet<ConstrainedElement.ConstrainedElementKind> SUPPORTED_ELEMENT_KINDS = EnumSet.of(ConstrainedElement.ConstrainedElementKind.TYPE, ConstrainedElement.ConstrainedElementKind.FIELD, ConstrainedElement.ConstrainedElementKind.METHOD);
        private final String propertyName;
        private final Map<Member, Cascadable.Builder> cascadableBuilders = new HashMap<Member, Cascadable.Builder>();
        private final Type propertyType;

        public Builder(Class<?> beanClass, ConstrainedField constrainedField, ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager) {
            super(beanClass, constraintHelper, typeResolutionHelper, valueExtractorManager);
            this.propertyName = constrainedField.getField().getName();
            this.propertyType = ReflectionHelper.typeOf(constrainedField.getField());
            this.add(constrainedField);
        }

        public Builder(Class<?> beanClass, ConstrainedType constrainedType, ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager) {
            super(beanClass, constraintHelper, typeResolutionHelper, valueExtractorManager);
            this.propertyName = null;
            this.propertyType = null;
            this.add(constrainedType);
        }

        public Builder(Class<?> beanClass, ConstrainedExecutable constrainedMethod, ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager) {
            super(beanClass, constraintHelper, typeResolutionHelper, valueExtractorManager);
            this.propertyName = ReflectionHelper.getPropertyName(constrainedMethod.getExecutable());
            this.propertyType = ReflectionHelper.typeOf(constrainedMethod.getExecutable());
            this.add(constrainedMethod);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (!SUPPORTED_ELEMENT_KINDS.contains((Object)constrainedElement.getKind())) {
                return false;
            }
            if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && !((ConstrainedExecutable)constrainedElement).isGetterMethod()) {
                return false;
            }
            return Objects.equals(this.getPropertyName(constrainedElement), this.propertyName);
        }

        @Override
        public final void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            if (constrainedElement.isCascading() || !constrainedElement.getGroupConversions().isEmpty()) {
                if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.FIELD) {
                    Field field = ((ConstrainedField)constrainedElement).getField();
                    Cascadable.Builder builder = this.cascadableBuilders.get(field);
                    if (builder == null) {
                        builder = new FieldCascadable.Builder(field);
                        this.cascadableBuilders.put(field, builder);
                    }
                    builder.addGroupConversions(constrainedElement.getGroupConversions());
                    builder.addCascadingTypeParameters(constrainedElement.getCascadingTypeParameters());
                } else if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD) {
                    Method method = (Method)((ConstrainedExecutable)constrainedElement).getExecutable();
                    Cascadable.Builder builder = this.cascadableBuilders.get(method);
                    if (builder == null) {
                        builder = new GetterCascadable.Builder(method);
                        this.cascadableBuilders.put(method, builder);
                    }
                    builder.addGroupConversions(constrainedElement.getGroupConversions());
                    builder.addCascadingTypeParameters(constrainedElement.getCascadingTypeParameters());
                }
            }
        }

        @Override
        protected Set<MetaConstraint<?>> adaptConstraints(ConstrainedElement.ConstrainedElementKind kind, Set<MetaConstraint<?>> constraints) {
            if (kind == ConstrainedElement.ConstrainedElementKind.FIELD || kind == ConstrainedElement.ConstrainedElementKind.TYPE) {
                return constraints;
            }
            return constraints.stream().map(this::withGetterLocation).collect(Collectors.toSet());
        }

        private MetaConstraint<?> withGetterLocation(MetaConstraint<?> constraint) {
            ConstraintLocation adaptedLocation = ConstraintLocation.forGetter((Method)constraint.getLocation().getMember());
            if (constraint.getLocation() instanceof TypeArgumentConstraintLocation) {
                adaptedLocation = ConstraintLocation.forTypeArgument(adaptedLocation, ((TypeArgumentConstraintLocation)constraint.getLocation()).getTypeParameter(), constraint.getLocation().getTypeForValidatorResolution());
            }
            return MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, constraint.getDescriptor(), adaptedLocation);
        }

        private String getPropertyName(ConstrainedElement constrainedElement) {
            if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.FIELD) {
                return ReflectionHelper.getPropertyName(((ConstrainedField)constrainedElement).getField());
            }
            if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD) {
                return ReflectionHelper.getPropertyName(((ConstrainedExecutable)constrainedElement).getExecutable());
            }
            return null;
        }

        @Override
        public PropertyMetaData build() {
            Set cascadables = this.cascadableBuilders.values().stream().map(b -> b.build()).collect(Collectors.toSet());
            return new PropertyMetaData(this.propertyName, this.propertyType, this.adaptOriginsAndImplicitGroups(this.getConstraints()), cascadables);
        }
    }
}

