/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.GroupConversionDescriptor;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;

public class GetterCascadable
implements Cascadable {
    private final Method method;
    private final String propertyName;
    private final Type cascadableType;
    private final List<CascadingTypeParameter> cascadingTypeParameters;
    private final GroupConversionHelper groupConversionHelper;

    GetterCascadable(Method method, List<CascadingTypeParameter> cascadingTypeParameters, Map<Class<?>, Class<?>> groupConversions) {
        this.method = method;
        this.propertyName = ReflectionHelper.getPropertyName(method);
        this.cascadableType = ReflectionHelper.typeOf(method);
        this.cascadingTypeParameters = Collections.unmodifiableList(cascadingTypeParameters);
        this.groupConversionHelper = new GroupConversionHelper(groupConversions);
        this.groupConversionHelper.validateGroupConversions(!cascadingTypeParameters.isEmpty(), method.toString());
    }

    @Override
    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConversionHelper.convertGroup(originalGroup);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    @Override
    public Type getCascadableType() {
        return this.cascadableType;
    }

    @Override
    public Object getValue(Object parent) {
        return ReflectionHelper.getValue(this.method, parent);
    }

    @Override
    public void appendTo(PathImpl path) {
        path.addPropertyNode(this.propertyName);
    }

    @Override
    public List<CascadingTypeParameter> getCascadingTypeParameters() {
        return this.cascadingTypeParameters;
    }

    public static class Builder
    implements Cascadable.Builder {
        private static final Log LOG = LoggerFactory.make();
        private final Method method;
        private final List<CascadingTypeParameter> cascadingTypeParameters = new ArrayList<CascadingTypeParameter>();
        private final Map<Class<?>, Class<?>> groupConversions = new HashMap();

        public Builder(Method method) {
            this.method = method;
        }

        @Override
        public void addCascadingTypeParameters(List<CascadingTypeParameter> cascadingTypeParameters) {
            this.cascadingTypeParameters.addAll(cascadingTypeParameters);
        }

        @Override
        public void addGroupConversions(Map<Class<?>, Class<?>> groupConversions) {
            for (Map.Entry<Class<?>, Class<?>> oneConversion : groupConversions.entrySet()) {
                if (this.groupConversions.containsKey(oneConversion.getKey())) {
                    throw LOG.getMultipleGroupConversionsForSameSourceException(oneConversion.getKey(), CollectionHelper.asSet(groupConversions.get(oneConversion.getKey()), oneConversion.getValue()));
                }
                this.groupConversions.put(oneConversion.getKey(), oneConversion.getValue());
            }
        }

        @Override
        public GetterCascadable build() {
            return new GetterCascadable(this.getAccessible(this.method), this.cascadingTypeParameters, this.groupConversions);
        }

        private Method getAccessible(Method original) {
            if (original.isAccessible()) {
                return original;
            }
            Class<?> clazz = original.getDeclaringClass();
            Method member = this.run(GetDeclaredMethod.action(clazz, original.getName(), new Class[0]));
            this.run(SetAccessibility.action(member));
            return member;
        }

        private <T> T run(PrivilegedAction<T> action) {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
    }
}

