/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.GroupConversionDescriptor;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;

public class FieldCascadable
implements Cascadable {
    private final Field field;
    private final String propertyName;
    private final Type cascadableType;
    private final List<CascadingTypeParameter> cascadingTypeParameters;
    private final GroupConversionHelper groupConversionHelper;

    FieldCascadable(Field field, List<CascadingTypeParameter> cascadingTypeParameters, Map<Class<?>, Class<?>> groupConversions) {
        this.field = field;
        this.propertyName = field.getName();
        this.cascadableType = ReflectionHelper.typeOf(field);
        this.cascadingTypeParameters = Collections.unmodifiableList(cascadingTypeParameters);
        this.groupConversionHelper = new GroupConversionHelper(groupConversions);
        this.groupConversionHelper.validateGroupConversions(!cascadingTypeParameters.isEmpty(), field.toString());
    }

    @Override
    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConversionHelper.convertGroup(originalGroup);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    @Override
    public Type getCascadableType() {
        return this.cascadableType;
    }

    @Override
    public Object getValue(Object parent) {
        return ReflectionHelper.getValue(this.field, parent);
    }

    @Override
    public void appendTo(PathImpl path) {
        path.addPropertyNode(this.propertyName);
    }

    @Override
    public List<CascadingTypeParameter> getCascadingTypeParameters() {
        return this.cascadingTypeParameters;
    }

    public static class Builder
    implements Cascadable.Builder {
        private static final Log LOG = LoggerFactory.make();
        private final Field field;
        private final List<CascadingTypeParameter> cascadingTypeParameters = new ArrayList<CascadingTypeParameter>();
        private final Map<Class<?>, Class<?>> groupConversions = new HashMap();

        public Builder(Field field) {
            this.field = field;
        }

        @Override
        public void addCascadingTypeParameters(List<CascadingTypeParameter> cascadingTypeParameters) {
            this.cascadingTypeParameters.addAll(cascadingTypeParameters);
        }

        @Override
        public void addGroupConversions(Map<Class<?>, Class<?>> groupConversions) {
            for (Map.Entry<Class<?>, Class<?>> oneConversion : groupConversions.entrySet()) {
                if (this.groupConversions.containsKey(oneConversion.getKey())) {
                    throw LOG.getMultipleGroupConversionsForSameSourceException(oneConversion.getKey(), CollectionHelper.asSet(groupConversions.get(oneConversion.getKey()), oneConversion.getValue()));
                }
                this.groupConversions.put(oneConversion.getKey(), oneConversion.getValue());
            }
        }

        @Override
        public FieldCascadable build() {
            return new FieldCascadable(this.getAccessible(this.field), this.cascadingTypeParameters, this.groupConversions);
        }

        private Field getAccessible(Field original) {
            if (original.isAccessible()) {
                return original;
            }
            Class<?> clazz = original.getDeclaringClass();
            Field member = this.run(GetDeclaredField.action(clazz, original.getName()));
            this.run(SetAccessibility.action(member));
            return member;
        }

        private <T> T run(PrivilegedAction<T> action) {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
    }
}

