/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.cascading;

import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.engine.cascading.AnnotatedObject;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.engine.cascading.BooleanArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ByteArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.CharArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.DoubleArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.FloatArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.IntArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.IterableValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyIterableValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyListValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyMapValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyOptionalValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ListValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LongArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.MapKeyExtractor;
import org.hibernate.validator.internal.engine.cascading.MapValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ObjectArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ObjectValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ObservableValueValueExtractor;
import org.hibernate.validator.internal.engine.cascading.OptionalValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ShortArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorDescriptor;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.TypeVariableBindings;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;

public class ValueExtractorManager {
    private final List<ValueExtractorDescriptor> valueExtractors;

    public ValueExtractorManager(Iterable<ValueExtractor<?>> externalExtractors) {
        ArrayList<ValueExtractorDescriptor> tmpValueExtractors = new ArrayList<ValueExtractorDescriptor>();
        for (ValueExtractor<?> valueExtractor : externalExtractors) {
            tmpValueExtractors.add(new ValueExtractorDescriptor(valueExtractor));
        }
        if (this.isJavaFxInClasspath()) {
            tmpValueExtractors.add(new ValueExtractorDescriptor(ObservableValueValueExtractor.INSTANCE));
        }
        tmpValueExtractors.add(new ValueExtractorDescriptor(LegacyListValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(ListValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(ByteArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(ShortArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(IntArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(LongArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(FloatArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(DoubleArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(CharArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(BooleanArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(ObjectArrayValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(LegacyMapValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(MapValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(MapKeyExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(LegacyIterableValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(IterableValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(LegacyOptionalValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(OptionalValueExtractor.INSTANCE));
        tmpValueExtractors.add(new ValueExtractorDescriptor(ObjectValueExtractor.INSTANCE));
        this.valueExtractors = Collections.unmodifiableList(tmpValueExtractors);
    }

    public ValueExtractorDescriptor getValueExtractor(Class<?> valueType) {
        List typeCompatibleExtractors = this.valueExtractors.stream().filter(e -> TypeHelper.isAssignable(TypeHelper.getErasedReferenceType(e.getExtractedType()), valueType)).collect(Collectors.toList());
        if (typeCompatibleExtractors.isEmpty()) {
            return null;
        }
        return (ValueExtractorDescriptor)typeCompatibleExtractors.iterator().next();
    }

    public ValueExtractorDescriptor getValueExtractor(Class<?> valueType, TypeVariable<?> typeParameter) {
        Map<Class<?>, Map<TypeVariable<?>, TypeVariable<?>>> allBindings = null;
        if (typeParameter != AnnotatedObject.INSTANCE && typeParameter != ArrayElement.INSTANCE) {
            allBindings = TypeVariableBindings.getTypeVariableBindings((Class)typeParameter.getGenericDeclaration());
        }
        List typeCompatibleExtractors = this.valueExtractors.stream().filter(e -> TypeHelper.isAssignable(TypeHelper.getErasedReferenceType(e.getExtractedType()), valueType)).collect(Collectors.toList());
        for (ValueExtractorDescriptor extractorDescriptor : typeCompatibleExtractors) {
            TypeVariable<?> typeParameterBoundToExtractorType;
            if (typeParameter != AnnotatedObject.INSTANCE && typeParameter != ArrayElement.INSTANCE) {
                Map<TypeVariable<?>, TypeVariable<?>> bindingsForExtractorType = allBindings.get(TypeHelper.getErasedReferenceType(extractorDescriptor.getExtractedType()));
                typeParameterBoundToExtractorType = this.bind(typeParameter, bindingsForExtractorType);
            } else {
                typeParameterBoundToExtractorType = typeParameter;
            }
            if (!typeParameterBoundToExtractorType.equals(extractorDescriptor.getExtractedTypeParameter())) continue;
            return extractorDescriptor;
        }
        return null;
    }

    private TypeVariable<?> bind(TypeVariable<?> typeParameter, Map<TypeVariable<?>, TypeVariable<?>> bindings) {
        AnnotatedObject bound = null;
        if (bindings != null) {
            bound = bindings.get(typeParameter);
        }
        return bound != null ? bound : (typeParameter == AnnotatedObject.INSTANCE ? AnnotatedObject.INSTANCE : ArrayElement.INSTANCE);
    }

    private boolean isJavaFxInClasspath() {
        return this.isClassPresent("javafx.application.Application", false);
    }

    private boolean isClassPresent(String className, boolean fallbackOnTCCL) {
        try {
            this.run(LoadClass.action(className, this.getClass().getClassLoader(), fallbackOnTCCL));
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

