/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.cascading;

import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.validation.valueextraction.ExtractedValue;
import javax.validation.valueextraction.UnwrapByDefault;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.engine.cascading.AnnotatedObject;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValueExtractorDescriptor {
    private static final Log LOG = LoggerFactory.make();
    private final ValueExtractor<?> valueExtractor;
    private final Type extractedType;
    private final TypeVariable<?> extractedTypeParameter;
    private final boolean unwrapByDefault;

    public ValueExtractorDescriptor(ValueExtractor<?> valueExtractor) {
        this.valueExtractor = valueExtractor;
        this.extractedTypeParameter = ValueExtractorDescriptor.getExtractedTypeParameter(valueExtractor.getClass());
        this.extractedType = ValueExtractorDescriptor.getExtractedType(valueExtractor.getClass());
        this.unwrapByDefault = ValueExtractorDescriptor.hasUnwrapByDefaultAnnotation(valueExtractor.getClass());
    }

    private static TypeVariable<?> getExtractedTypeParameter(Class<?> extractorImplementationType) {
        AnnotatedType genericInterface = extractorImplementationType.getAnnotatedInterfaces()[0];
        AnnotatedType extractedType = ((AnnotatedParameterizedType)genericInterface).getAnnotatedActualTypeArguments()[0];
        Class extractedTypeRaw = (Class)TypeHelper.getErasedType(extractedType.getType());
        TypeVariable<Class<Object>> extractedTypeParameter = null;
        if (extractedType.isAnnotationPresent(ExtractedValue.class)) {
            extractedTypeParameter = extractedType instanceof AnnotatedArrayType ? ArrayElement.INSTANCE : AnnotatedObject.INSTANCE;
        }
        if (extractedType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedExtractedType = (AnnotatedParameterizedType)extractedType;
            int i = 0;
            for (AnnotatedType typeArgument : parameterizedExtractedType.getAnnotatedActualTypeArguments()) {
                if (typeArgument.isAnnotationPresent(ExtractedValue.class)) {
                    if (extractedTypeParameter != null) {
                        throw LOG.getValueExtractorDeclaresExtractedValueMultipleTimesException(extractorImplementationType);
                    }
                    extractedTypeParameter = extractedTypeRaw.getTypeParameters()[i];
                }
                ++i;
            }
        }
        if (extractedTypeParameter == null) {
            throw LOG.getValueExtractorFailsToDeclareExtractedValueException(extractorImplementationType);
        }
        return extractedTypeParameter;
    }

    private static Type getExtractedType(Class<?> extractorImplementationType) {
        AnnotatedType genericInterface = extractorImplementationType.getAnnotatedInterfaces()[0];
        AnnotatedType extractedType = ((AnnotatedParameterizedType)genericInterface).getAnnotatedActualTypeArguments()[0];
        return extractedType.getType();
    }

    private static boolean hasUnwrapByDefaultAnnotation(Class<?> extractorImplementationType) {
        return extractorImplementationType.isAnnotationPresent(UnwrapByDefault.class);
    }

    public Type getExtractedType() {
        return this.extractedType;
    }

    public TypeVariable<?> getExtractedTypeParameter() {
        return this.extractedTypeParameter;
    }

    public ValueExtractor<?> getValueExtractor() {
        return this.valueExtractor;
    }

    public boolean isUnwrapByDefault() {
        return this.unwrapByDefault;
    }

    public String toString() {
        return "ValueExtractorDescriptor [valueExtractor=" + StringHelper.toShortString(this.valueExtractor.getClass()) + ", extractedType=" + StringHelper.toShortString(this.extractedType) + ", extractedTypeParameter=" + this.extractedTypeParameter + ", unwrapByDefault=" + this.unwrapByDefault + "]";
    }
}

