/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.reflection.java.generics;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironmentFactory;
import org.hibernate.annotations.common.test.reflection.java.generics.Dad;
import org.hibernate.annotations.common.test.reflection.java.generics.Grandpa;
import org.hibernate.annotations.common.test.reflection.java.generics.Son;

public class TypeEnvironmentFactoryTest
extends TestCase {
    public void testBindsGenericsToSuperclassEnvironment() throws SecurityException, NoSuchMethodException {
        TypeEnvironmentFactory env = new TypeEnvironmentFactory();
        Type type = Grandpa.class.getMethod("returnsGeneric", new Class[0]).getGenericReturnType();
        Type asSeenFromGrandpa = env.getEnvironment(Grandpa.class).bind(type);
        TypeEnvironmentFactoryTest.assertTrue((boolean)(asSeenFromGrandpa instanceof TypeVariable));
        TypeEnvironmentFactoryTest.assertEquals((String)"T", (String)asSeenFromGrandpa.toString());
        Type asSeenFromDad = env.getEnvironment(Dad.class).bind(type);
        TypeEnvironmentFactoryTest.assertTrue((boolean)(asSeenFromDad instanceof ParameterizedType));
        TypeEnvironmentFactoryTest.assertEquals((String)"java.util.List<T>", (String)asSeenFromDad.toString());
        ParameterizedType asSeenFromSon = (ParameterizedType)env.getEnvironment(Son.class).bind(type);
        this.assertType_isCollectionOfClass_withElementsOfClass(asSeenFromSon, List.class, String.class);
    }

    public void testBindsGenericsToOwnerEnvironment() throws SecurityException, NoSuchMethodException {
        TypeEnvironmentFactory env = new TypeEnvironmentFactory();
        Type friendType = Dad.class.getMethod("getFriend", new Class[0]).getGenericReturnType();
        ParameterizedType friendTypeAsSeenFromDad = (ParameterizedType)env.getEnvironment(Dad.class).bind(friendType);
        Class friendClass = (Class)friendTypeAsSeenFromDad.getRawType();
        Type returnType = friendClass.getMethod("embeddedProperty", new Class[0]).getGenericReturnType();
        ParameterizedType boundType = (ParameterizedType)env.getEnvironment((Type)friendTypeAsSeenFromDad).bind(returnType);
        this.assertType_isCollectionOfClass_withElementsOfClass(boundType, Set.class, Integer.class);
    }

    private void assertType_isCollectionOfClass_withElementsOfClass(ParameterizedType t, Class collectionClass, Class elementClass) {
        TypeEnvironmentFactoryTest.assertEquals((Object)collectionClass, (Object)t.getRawType());
        TypeEnvironmentFactoryTest.assertEquals((int)1, (int)t.getActualTypeArguments().length);
        TypeEnvironmentFactoryTest.assertEquals((Object)elementClass, (Object)t.getActualTypeArguments()[0]);
    }
}

