/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.form.TaskFormData;
import org.flowable.engine.impl.form.FormEngine;
import org.flowable.engine.impl.form.TaskFormHandler;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.FormHandlerUtil;
import org.flowable.engine.task.Task;

public class GetRenderedTaskFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String formEngineName;

    public GetRenderedTaskFormCmd(String taskId, String formEngineName) {
        this.taskId = taskId;
        this.formEngineName = formEngineName;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("Task id should not be null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("Task '" + this.taskId + "' not found", Task.class);
        }
        TaskFormHandler taskFormHandler = FormHandlerUtil.getTaskFormHandlder(task);
        if (taskFormHandler != null) {
            FormEngine formEngine = commandContext.getProcessEngineConfiguration().getFormEngines().get(this.formEngineName);
            if (formEngine == null) {
                throw new FlowableException("No formEngine '" + this.formEngineName + "' defined process engine configuration");
            }
            TaskFormData taskForm = taskFormHandler.createTaskForm(task);
            return formEngine.renderTaskForm(taskForm);
        }
        return null;
    }
}

