/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.task.IdentityLink;

public class GetIdentityLinksForProcessInstanceCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public GetIdentityLinksForProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        ExecutionEntity processInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
        if (processInstance == null) {
            throw new FlowableObjectNotFoundException("Cannot find process definition with id " + this.processInstanceId, ExecutionEntity.class);
        }
        return processInstance.getIdentityLinks();
    }
}

