/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor;

import java.util.Collection;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.runtime.Job;

public class ResetExpiredJobsCmd
implements Command<Void> {
    protected Collection<String> jobIds;

    public ResetExpiredJobsCmd(Collection<String> jobsIds) {
        this.jobIds = jobsIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        boolean messageQueueMode = commandContext.getProcessEngineConfiguration().isAsyncExecutorIsMessageQueueMode();
        for (String jobId : this.jobIds) {
            if (!messageQueueMode) {
                Job job = (Job)commandContext.getJobEntityManager().findById(jobId);
                commandContext.getJobManager().unacquire(job);
                continue;
            }
            commandContext.getJobEntityManager().resetExpiredJob(jobId);
        }
        return null;
    }
}

