/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor;

import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.ExecuteAsyncJobCmd;
import org.flowable.engine.impl.cmd.LockExclusiveJobCmd;
import org.flowable.engine.impl.cmd.UnlockExclusiveJobCmd;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ExecuteAsyncRunnable.class);
    protected String jobId;
    protected Job job;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ExecuteAsyncRunnable(String jobId, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.jobId = jobId;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public ExecuteAsyncRunnable(Job job, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.job = job;
        this.jobId = job.getId();
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public void run() {
        if (this.job == null) {
            this.job = this.processEngineConfiguration.getCommandExecutor().execute(new Command<JobEntity>(){

                @Override
                public JobEntity execute(CommandContext commandContext) {
                    return (JobEntity)commandContext.getJobEntityManager().findById(ExecuteAsyncRunnable.this.jobId);
                }
            });
        }
        if (this.isHandledByV5Engine()) {
            return;
        }
        boolean lockNotNeededOrSuccess = this.lockJobIfNeeded();
        if (lockNotNeededOrSuccess) {
            this.executeJob();
            this.unlockJobIfNeeded();
        }
    }

    protected boolean isHandledByV5Engine() {
        boolean isFlowable5ProcessDefinition = Flowable5Util.isFlowable5ProcessDefinitionId(this.processEngineConfiguration, this.job.getProcessDefinitionId());
        if (isFlowable5ProcessDefinition) {
            return this.processEngineConfiguration.getCommandExecutor().execute(new Command<Boolean>(){

                @Override
                public Boolean execute(CommandContext commandContext) {
                    commandContext.getProcessEngineConfiguration().getFlowable5CompatibilityHandler().executeJobWithLockAndRetry(ExecuteAsyncRunnable.this.job);
                    return true;
                }
            });
        }
        return false;
    }

    protected void executeJob() {
        try {
            this.processEngineConfiguration.getCommandExecutor().execute(new ExecuteAsyncJobCmd(this.jobId));
        }
        catch (FlowableOptimisticLockingException e) {
            this.handleFailedJob(e);
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception during job execution. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor threads running against the same database. Exception message: {}", (Object)e.getMessage());
            }
        }
        catch (Throwable exception) {
            this.handleFailedJob(exception);
            String message = "Job " + this.jobId + " failed";
            log.error(message, exception);
        }
    }

    protected void unlockJobIfNeeded() {
        try {
            if (this.job.isExclusive()) {
                this.processEngineConfiguration.getCommandExecutor().execute(new UnlockExclusiveJobCmd(this.job));
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception while unlocking the job. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable t) {
            log.error("Error while unlocking exclusive job {}", (Object)this.job.getId(), (Object)t);
        }
    }

    protected boolean lockJobIfNeeded() {
        try {
            if (this.job.isExclusive()) {
                this.processEngineConfiguration.getCommandExecutor().execute(new LockExclusiveJobCmd(this.job));
            }
        }
        catch (Throwable lockException) {
            if (log.isDebugEnabled()) {
                log.debug("Could not lock exclusive job. Unlocking job so it can be acquired again. Caught exception: {}", (Object)lockException.getMessage());
            }
            this.unacquireJob();
            return false;
        }
        return true;
    }

    protected void unacquireJob() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getJobManager().unacquire(this.job);
        } else {
            this.processEngineConfiguration.getCommandExecutor().execute(new Command<Void>(){

                @Override
                public Void execute(CommandContext commandContext) {
                    commandContext.getJobManager().unacquire(ExecuteAsyncRunnable.this.job);
                    return null;
                }
            });
        }
    }

    protected void handleFailedJob(final Throwable exception) {
        this.processEngineConfiguration.getCommandExecutor().execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                if (ExecuteAsyncRunnable.this.job.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, ExecuteAsyncRunnable.this.job.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.handleFailedJob(ExecuteAsyncRunnable.this.job, exception);
                    return null;
                }
                CommandConfig commandConfig = ExecuteAsyncRunnable.this.processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
                Command<Object> cmd = failedJobCommandFactory.getCommand(ExecuteAsyncRunnable.this.job.getId(), exception);
                log.trace("Using FailedJobCommandFactory '{}' and command of type '{}'", failedJobCommandFactory.getClass(), cmd.getClass());
                ExecuteAsyncRunnable.this.processEngineConfiguration.getCommandExecutor().execute(commandConfig, cmd);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    try {
                        commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityExceptionEvent(FlowableEngineEventType.JOB_EXECUTION_FAILURE, ExecuteAsyncRunnable.this.job, exception));
                    }
                    catch (Throwable ignore) {
                        log.warn("Exception occurred while dispatching job failure event, ignoring.", ignore);
                    }
                }
                return null;
            }
        });
    }
}

